set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '4',
      '1',
      '2',
      NULL,
      '4',
      '3',
      '4',
      '4',
      '1',
      NULL,
      '3',
      '0',
      '3',
      '1',
      '4',
      '2',
      '4',
      NULL,
      '4',
      '1',
      '3',
      '0',
      '',
      NULL,
      '',
      '0',
      NULL,
      '4',
      '1',
      '0',
      '',
      '',
      '4',
      '1',
      NULL,
      '4',
      '0',
      '1',
      '0',
      '2',
      '3',
      '2',
      '4',
      '442',
      NULL,
      80.302919,
      11.286537,
      NULL,
      3,
      110,
      0,
      NULL,
      '114113',
      1,
      NULL,
      ' 8-24-1975',
      NULL,
      210.303811,
      12,
      10.171356,
      7,
      2,
      75,
      2,
      22.193836,
      11,
      4.483481,
      1,
      21,
      16,
      28.377659,
      0,
      11,
      24.498158,
      38.106237,
      11,
      55.906042,
      14.254688,
      56.238760,
      7,
      1,
      109.519442,
      36,
      NULL,
      141,
      NULL,
      NULL,
      ' 5- 3-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      6,
      6,
      17,
      2.341196,
      ' 6-17-1999',
      0.773792,
      0,
      179,
      0.095582,
      0,
      30.092838,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1989',
      55.369602,
      15,
      NULL,
      19.888513,
      88,
      NULL,
      9,
      30,
      6,
      5.134859,
      35.135512,
      NULL,
      ' 6-18-1994',
      NULL,
      1.265558,
      NULL,
      44.817709,
      38,
      6,
      NULL,
      ' 4-18-1984',
      3,
      10,
      ' 8-27-1983',
      4.932174,
      0.276351,
      0,
      12.997640,
      2.907421,
      2,
      1.823439,
      10,
      0.257111,
      36.532813,
      0.942487,
      0,
      NULL,
      24,
      1.019285,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      ' 9-24-1986',
      NULL,
      NULL,
      NULL,
      36.974402,
      '11- 2-2003',
      6.624187,
      NULL,
      14,
      4.125874,
      ' 2-13-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6.308526,
      ' 2-23-1978',
      27.750663,
      17.503379,
      51,
      NULL,
      NULL,
      159,
      ' 5-19-1985',
      8,
      45,
      NULL,
      NULL,
      ' 0-10-1980',
      NULL,
      0,
      51,
      ' 9-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


