set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7909684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4401',
      '04422403',
      NULL,
      '01120244',
      NULL,
      '00212041',
      '41043432',
      '33432212',
      '31411300',
      '02442110',
      NULL,
      '13204143',
      '13414141',
      '03000414',
      '42222313',
      '11021113',
      '22303302',
      NULL,
      '44022202',
      '20120224',
      '00042342',
      NULL,
      '24002302',
      '03443422',
      '02243004',
      NULL,
      '03030220',
      '03124340',
      '41323400',
      '04301403',
      '41114034',
      '01033234',
      '30034001',
      NULL,
      '22042134',
      '40332221',
      '22034330',
      '41010214',
      '00301132',
      NULL,
      NULL,
      '02421111',
      '44321030',
      '30101042',
      '01314030',
      '320',
      '03',
      9,
      12,
      NULL,
      NULL,
      1.801317,
      0,
      NULL,
      '412311',
      5,
      NULL,
      ' 5- 4-1976',
      83.974883,
      7.557837,
      13.022730,
      NULL,
      27.447393,
      7,
      31.361014,
      9.660875,
      NULL,
      3.486811,
      NULL,
      5,
      9.213020,
      14.918247,
      23,
      5,
      5.613648,
      8.382822,
      14.474916,
      4,
      42.163114,
      4,
      14,
      3.050344,
      1.953699,
      NULL,
      NULL,
      6,
      62,
      20.478017,
      66,
      ' 2-12-1989',
      15,
      21.675128,
      NULL,
      4,
      100.666114,
      NULL,
      ' 0-29-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.666561,
      14.116203,
      5.890530,
      3.827853,
      0.536351,
      ' 3-26-1987',
      NULL,
      0.821493,
      153.767379,
      1.287399,
      0,
      8.494638,
      NULL,
      NULL,
      22.613284,
      NULL,
      NULL,
      NULL,
      '11-13-1994',
      72.241391,
      112.108986,
      46.678624,
      39,
      69.990000,
      50,
      26,
      53.328540,
      55,
      5,
      50.185098,
      NULL,
      ' 9-24-1978',
      16,
      8,
      5.463211,
      28,
      55,
      45.204835,
      7,
      NULL,
      19.141064,
      10.097489,
      ' 6-20-1978',
      10.223555,
      9,
      NULL,
      9,
      0.562534,
      4,
      3.357523,
      2.221579,
      0.097018,
      49,
      5.106946,
      3,
      8.617937,
      17.177025,
      NULL,
      2,
      6.009842,
      0.122852,
      ' 4-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      142,
      NULL,
      ' 7-24-1977',
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      ' 0- 3-2000',
      NULL,
      2,
      ' 1-10-1977',
      68,
      17,
      ' 8- 2-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      ' 7-24-1985',
      NULL,
      NULL,
      NULL,
      ' 0-17-1981',
      0.534429,
      109,
      ' 2- 1-1974',
      0,
      69,
      19,
      35,
      ' 4-19-1985',
      24,
      0,
      218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


