set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8032948';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '2',
      '2',
      '4',
      '0',
      '2',
      '4',
      '0',
      NULL,
      '1',
      '0',
      '2',
      '4',
      '2',
      NULL,
      '0',
      NULL,
      '0',
      '1',
      '3',
      '1',
      '4',
      '2',
      '',
      NULL,
      '',
      '3',
      '0',
      '4',
      '3',
      '0',
      '',
      '',
      NULL,
      '3',
      '1',
      NULL,
      '2',
      '2',
      '4',
      '2',
      '1',
      '3',
      '1',
      '034',
      '13202043',
      43.821538,
      NULL,
      '2024121',
      3,
      0,
      0,
      0,
      '242434',
      4.790439,
      '11- 9-1996',
      '10-24-1982',
      49,
      98.437821,
      NULL,
      7.962347,
      1.563620,
      17,
      54,
      15,
      25,
      8.928107,
      24,
      0,
      19,
      20.380594,
      30,
      8.811402,
      25,
      1.809214,
      87,
      15,
      65,
      18.988806,
      78.833948,
      NULL,
      0.083164,
      102.123697,
      3,
      NULL,
      67.859467,
      43.622929,
      173,
      NULL,
      NULL,
      40.940495,
      20.841029,
      24,
      73.978071,
      90,
      ' 8- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.923017,
      11,
      6.958565,
      7,
      5,
      NULL,
      NULL,
      0.308994,
      1.466619,
      76,
      NULL,
      0.401378,
      153,
      1,
      0,
      63.438259,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      84,
      83.116348,
      91.787032,
      44,
      131,
      2,
      41.068938,
      52.497821,
      13.073280,
      NULL,
      NULL,
      '10- 4-1990',
      16,
      NULL,
      37.902465,
      NULL,
      28,
      113,
      NULL,
      '11- 1-1997',
      NULL,
      20.093242,
      '11-14-1974',
      9,
      15,
      8,
      21.728413,
      12.532149,
      NULL,
      NULL,
      4.657758,
      0,
      131,
      NULL,
      0.746793,
      21,
      11,
      0,
      0,
      1,
      1.396403,
      '10-10-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      230.264604,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      ' 2-19-2003',
      13,
      4,
      ' 6-25-1989',
      53,
      7.417422,
      ' 9-25-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      14.139956,
      '11-12-1990',
      40.895190,
      22,
      24.181388,
      '10- 1-1977',
      1,
      30,
      ' 7-19-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


