set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '0',
      '0',
      '3',
      '4',
      '2',
      NULL,
      '2',
      '4',
      '3',
      '0',
      '2',
      '0',
      '3',
      '2',
      '4',
      '4',
      '0',
      '0',
      '4',
      '4',
      '2',
      '2',
      '',
      NULL,
      '',
      '2',
      '0',
      NULL,
      '4',
      '2',
      '',
      '',
      '0',
      '4',
      '4',
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '2',
      '2',
      '440',
      '41131403',
      3.818647,
      4.899151,
      '3130320',
      NULL,
      1.213980,
      2,
      NULL,
      '003431',
      0.254936,
      ' 6-23-1990',
      ' 3-18-1976',
      212.079749,
      14,
      20.550230,
      12.838794,
      NULL,
      6.151208,
      44,
      NULL,
      NULL,
      NULL,
      5,
      12,
      28.610039,
      16,
      8.246654,
      NULL,
      12,
      7.162929,
      NULL,
      23.188457,
      8,
      3,
      NULL,
      NULL,
      NULL,
      54.277323,
      56.370401,
      NULL,
      84.098190,
      133,
      69.729010,
      ' 0-13-1985',
      37,
      4,
      5.134076,
      11,
      88.145350,
      NULL,
      ' 3-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      3.833342,
      1.028165,
      3,
      7,
      ' 7- 9-2000',
      3.734144,
      NULL,
      68.283072,
      1.802552,
      1,
      67.577464,
      1,
      1.176298,
      1,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1980',
      12.724764,
      87.568326,
      67.889140,
      NULL,
      51,
      93.181721,
      37.589803,
      NULL,
      62,
      85,
      15,
      95,
      '11-21-1994',
      20.570119,
      12,
      15.810351,
      59.970926,
      47,
      75.593267,
      2.103432,
      ' 2- 1-1981',
      0.020150,
      7.582421,
      ' 9-25-1997',
      4,
      11.934375,
      NULL,
      4,
      15.663510,
      10,
      0.365662,
      3.945176,
      1,
      19.903103,
      3,
      1.120550,
      0,
      17,
      10.114686,
      1.637718,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      38,
      ' 9- 9-2001',
      NULL,
      NULL,
      NULL,
      47.416221,
      ' 9-10-1993',
      NULL,
      ' 0- 8-1977',
      21,
      7.470270,
      ' 6-24-2001',
      45.073182,
      81.727182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      17.579385,
      ' 8- 2-1993',
      37,
      34.358982,
      4.076071,
      ' 5-14-1981',
      0.378477,
      127,
      ' 6-18-1976',
      NULL,
      31,
      NULL,
      47,
      NULL,
      24,
      1.904362,
      39.114346,
      ' 6- 3-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


