set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '3',
      '0',
      '4',
      '3',
      '1',
      '3',
      '0',
      '2',
      '2',
      '0',
      '4',
      '3',
      '1',
      '3',
      '0',
      '3',
      '2',
      NULL,
      '1',
      NULL,
      '0',
      NULL,
      NULL,
      '1',
      '',
      NULL,
      '2',
      '0',
      '2',
      '2',
      NULL,
      '',
      '2',
      '1',
      '4',
      '0',
      '2',
      '4',
      '0',
      '4',
      '2',
      '1',
      '4',
      NULL,
      '30044304',
      7.284661,
      70.642879,
      NULL,
      0,
      31,
      1,
      1,
      '332211',
      6,
      NULL,
      ' 2-11-2002',
      29.824443,
      NULL,
      22,
      9.694906,
      10,
      6,
      51.464282,
      9.768916,
      12.795934,
      0.908899,
      13,
      NULL,
      26,
      3,
      3,
      8,
      12,
      11.197867,
      19,
      NULL,
      NULL,
      18.073037,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      66,
      210,
      6.145815,
      10,
      ' 4-15-1988',
      32.595516,
      NULL,
      7.905487,
      9.324829,
      151,
      4.707894,
      ' 1-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.428235,
      2.742414,
      NULL,
      NULL,
      NULL,
      ' 4-10-1999',
      0.272162,
      1.504122,
      118,
      0.852683,
      NULL,
      96,
      0,
      0,
      43,
      NULL,
      NULL,
      NULL,
      ' 7- 2-1999',
      50,
      53,
      102.919890,
      83,
      102,
      93,
      28.695697,
      6,
      NULL,
      2,
      34.538883,
      47,
      NULL,
      NULL,
      19,
      7,
      65,
      NULL,
      NULL,
      5.470107,
      NULL,
      12.287082,
      15,
      NULL,
      15,
      NULL,
      25,
      11.635748,
      27,
      9.385413,
      0,
      16.817846,
      1,
      87.259037,
      1.027283,
      0.575304,
      NULL,
      7.673415,
      1,
      0.116975,
      0.689311,
      0,
      ' 2-11-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.548157,
      NULL,
      NULL,
      NULL,
      NULL,
      4.974684,
      NULL,
      11,
      NULL,
      2,
      NULL,
      ' 5- 1-1987',
      105.763893,
      79.783255,
      ' 2- 9-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.901145,
      ' 2-17-1977',
      11,
      7,
      2.990640,
      ' 9-26-1992',
      0,
      37,
      NULL,
      7.266976,
      17,
      NULL,
      NULL,
      ' 5-18-1988',
      NULL,
      1,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


