set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7922738';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3312',
      '21000231',
      '30143301',
      '31033413',
      '21020431',
      '23203010',
      NULL,
      '31342124',
      '41232343',
      '23124131',
      '43434234',
      '11311324',
      '14413042',
      NULL,
      '10311233',
      '04110223',
      '30314312',
      '10340002',
      NULL,
      '40413104',
      NULL,
      '43133112',
      '30000224',
      '30312321',
      '43411221',
      '03011420',
      '40143214',
      '43421102',
      NULL,
      '30234444',
      '33033322',
      '10411342',
      NULL,
      '43401434',
      '32212423',
      '44334332',
      NULL,
      '01113012',
      NULL,
      NULL,
      '11103213',
      '33212014',
      '21114133',
      '10113434',
      '31200114',
      NULL,
      NULL,
      NULL,
      NULL,
      '0022203',
      3,
      1,
      2,
      NULL,
      '110134',
      2,
      '11-27-1999',
      ' 5-26-1976',
      NULL,
      NULL,
      NULL,
      2.807147,
      9.366672,
      20.946811,
      21.984035,
      NULL,
      22,
      15.767214,
      9.816748,
      NULL,
      NULL,
      15.907917,
      NULL,
      7.394735,
      NULL,
      23,
      NULL,
      24,
      52,
      NULL,
      179.186141,
      18.167507,
      NULL,
      14.217605,
      71,
      114,
      134,
      268,
      145,
      ' 9- 1-1995',
      7.633487,
      NULL,
      28,
      27,
      NULL,
      38,
      ' 0-15-1977',
      1.465033,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.478887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-10-1998',
      21.776737,
      NULL,
      138,
      48.698028,
      NULL,
      9,
      23.466617,
      29.691689,
      18.682923,
      24.804978,
      NULL,
      112.822853,
      ' 8-13-1996',
      5.143820,
      52.437678,
      48.629490,
      19.164330,
      NULL,
      178,
      8.295586,
      ' 8- 0-1987',
      21.215394,
      5.481992,
      ' 6-13-1983',
      NULL,
      5,
      18.812890,
      22,
      NULL,
      11,
      NULL,
      15.402645,
      NULL,
      167,
      2.450678,
      8,
      2.493743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      NULL,
      8,
      ' 9-17-1975',
      NULL,
      10.286322,
      ' 9-25-1983',
      18,
      13.822167,
      14.379909,
      13.030880,
      ' 0- 0-1983',
      66,
      1.480372,
      11,
      ' 2-21-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.681291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539518,
      1.739495,
      0.833754,
      0,
      64,
      0.010858,
      NULL,
      93.074021,
      0,
      3.834424,
      90,
      NULL,
      21.049752,
      NULL,
      NULL,
      NULL,
      0,
      1.723793,
      0,
      0.318752,
      0.023488,
      1,
      NULL,
      NULL,
      NULL,
      15.031430,
      NULL,
      NULL,
      NULL,
      1.479059,
      8.972483,
      0,
      3.803104,
      5,
      40,
      1,
      NULL,
      1,
      NULL,
      1.466598,
      0,
      NULL,
      20.789968,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      5,
      1.561143,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 3-17-1988',
      ' 2- 7-1996',
      '10-13-1980',
      ' 1-12-1987',
      ' 6- 6-1985',
      NULL,
      NULL);
commit;
end;
/


