set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9777061';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '4',
      '1',
      '1',
      '1',
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '0',
      '4',
      '4',
      '1',
      '0',
      '4',
      '4',
      '2',
      '2',
      '3',
      '4',
      NULL,
      NULL,
      '',
      '0',
      '',
      '3',
      '3',
      NULL,
      '1',
      '0',
      '',
      '',
      '0',
      '0',
      '3',
      '2',
      '0',
      '1',
      '3',
      '3',
      '2',
      '3',
      '0',
      '424',
      '23224044',
      NULL,
      30.552254,
      '3114141',
      1,
      NULL,
      NULL,
      NULL,
      '233421',
      NULL,
      '11-25-2002',
      ' 7- 6-1990',
      186.809537,
      NULL,
      6,
      NULL,
      5.032719,
      24,
      9,
      2,
      2,
      19,
      28,
      9,
      10.429959,
      7.208949,
      5.407221,
      5,
      15,
      NULL,
      NULL,
      8,
      NULL,
      11,
      35.711245,
      25.638371,
      NULL,
      2,
      0.104279,
      86,
      89,
      46.639094,
      NULL,
      '10-13-2002',
      34.479733,
      NULL,
      13,
      3.383484,
      61.000569,
      4,
      ' 8-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      NULL,
      13,
      12.494743,
      12.949305,
      7,
      ' 6-18-1974',
      0.069586,
      0,
      156,
      1,
      NULL,
      18.782818,
      NULL,
      0,
      72,
      NULL,
      NULL,
      NULL,
      '10- 8-1976',
      NULL,
      70,
      38.378545,
      NULL,
      63.881278,
      68.121358,
      8.785534,
      80,
      84.678481,
      65.483894,
      62.125533,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      57.201494,
      NULL,
      129.224284,
      3,
      ' 2-16-1989',
      35,
      36.521524,
      NULL,
      6,
      NULL,
      14,
      5.302758,
      2,
      11.182746,
      1.468229,
      NULL,
      NULL,
      41.454368,
      5.158821,
      0.180721,
      7,
      8.313812,
      1.165181,
      0,
      0.558197,
      NULL,
      '11-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      16,
      ' 3- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1979',
      NULL,
      '11- 0-1976',
      NULL,
      0.066435,
      ' 2-28-2002',
      139,
      35.346146,
      ' 8- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.552001,
      NULL,
      NULL,
      22.340049,
      25.560782,
      '10- 3-1997',
      0,
      79.109047,
      ' 2-16-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


