set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6111742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2221',
      '02111413',
      '00422222',
      '24144131',
      '32020330',
      '31110012',
      '13123224',
      '00020120',
      '40431134',
      '40122301',
      '44234231',
      NULL,
      '44031421',
      '31330031',
      '12212400',
      '20321333',
      NULL,
      NULL,
      '30222013',
      '04123444',
      '40403340',
      NULL,
      '42111320',
      NULL,
      '41321231',
      '42340403',
      NULL,
      '33401121',
      '41101334',
      NULL,
      '04234043',
      NULL,
      '02000040',
      '31130140',
      '32220240',
      '11122004',
      '13433230',
      '10044310',
      '21213121',
      '02000441',
      '11424401',
      '21130432',
      '41300124',
      '03441402',
      '12130331',
      '222',
      '00',
      NULL,
      NULL,
      '4110341',
      3.883973,
      NULL,
      2,
      NULL,
      NULL,
      2,
      ' 0-25-1989',
      ' 0-24-1989',
      NULL,
      NULL,
      35,
      21.562751,
      NULL,
      NULL,
      91.863315,
      18,
      35.392645,
      13,
      34,
      23.659978,
      2.381877,
      16,
      NULL,
      NULL,
      2.229300,
      1,
      54.539323,
      16.092794,
      31,
      NULL,
      NULL,
      16.018085,
      1,
      2.089419,
      16,
      74,
      95.171480,
      145.476867,
      201.596758,
      '10-11-2001',
      26,
      32.205733,
      5,
      15,
      146.343865,
      161,
      ' 3-14-1982',
      NULL,
      0.917735,
      0,
      0,
      1.674007,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.558902,
      1.835345,
      0,
      1.753103,
      3.575337,
      0,
      1.736063,
      1.394913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      22.179158,
      NULL,
      3,
      18,
      NULL,
      ' 5-12-1987',
      NULL,
      0.334898,
      97.013140,
      0.262151,
      NULL,
      38,
      4,
      3.680522,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-20-1980',
      19.810129,
      0,
      NULL,
      17.981166,
      5.377917,
      NULL,
      81.733296,
      81,
      13,
      74.093884,
      75,
      7.926002,
      ' 8- 0-2000',
      NULL,
      1,
      NULL,
      75.053463,
      NULL,
      34.953633,
      1.571048,
      '11-25-1985',
      10.101334,
      11.932805,
      ' 1- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      2.177347,
      1.978632,
      13.434468,
      NULL,
      96,
      1,
      6.955927,
      5,
      6.977471,
      1,
      2.356847,
      1,
      0,
      NULL,
      3.304875,
      0.735493,
      2.408394,
      ' 1-26-1979',
      146.988111,
      1.256163,
      ' 4- 4-1998',
      29,
      2,
      '10- 4-2002',
      43.887903,
      ' 9- 8-1981',
      46.300234,
      ' 6- 9-1976',
      11,
      1,
      ' 8- 6-1979',
      NULL,
      43,
      '11- 5-1987',
      2.615513,
      1.058478,
      ' 7-13-1977',
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.350625,
      '11-27-1980',
      22,
      25,
      21.293847,
      ' 8-28-1979',
      0.574345,
      65.163915,
      '11- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


