set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8922959';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0011',
      '41141302',
      '04322422',
      '34223111',
      '40130310',
      NULL,
      NULL,
      '43422221',
      NULL,
      '22311101',
      '12013132',
      '00011234',
      '11222044',
      NULL,
      NULL,
      '02222243',
      '10221300',
      '32004234',
      '24331033',
      '34043012',
      NULL,
      '01330413',
      '23333313',
      '34011231',
      '11221241',
      '11441243',
      '24022003',
      NULL,
      '42003002',
      NULL,
      '02100023',
      '13013233',
      NULL,
      '42240240',
      NULL,
      '20332440',
      '00101330',
      '00321413',
      '23330021',
      NULL,
      '11122441',
      '30401232',
      '30303423',
      '04313140',
      '13042212',
      '034',
      '02',
      NULL,
      NULL,
      '4424121',
      NULL,
      1.482744,
      0,
      NULL,
      '204231',
      NULL,
      ' 1-25-2000',
      ' 2-27-1995',
      51,
      NULL,
      NULL,
      6,
      32,
      NULL,
      NULL,
      3,
      12,
      NULL,
      NULL,
      1,
      26.987949,
      16,
      31,
      25.814662,
      23.623712,
      3,
      62,
      15,
      NULL,
      6.960752,
      49,
      18,
      0,
      19,
      3.053123,
      NULL,
      118.889937,
      NULL,
      NULL,
      NULL,
      9,
      23.796263,
      35,
      23.267115,
      41,
      72,
      '11-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.891366,
      7.491933,
      1,
      2.728574,
      2,
      5.771752,
      ' 3-17-1978',
      1,
      0,
      67.817280,
      NULL,
      0,
      77,
      0,
      NULL,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      81,
      NULL,
      56.574840,
      NULL,
      84.546794,
      NULL,
      53,
      82,
      NULL,
      6.916260,
      ' 2-10-2001',
      NULL,
      18.950845,
      16,
      NULL,
      NULL,
      0.345655,
      0,
      ' 5-12-1983',
      NULL,
      NULL,
      ' 6- 3-1989',
      7.658520,
      9.475193,
      13,
      1,
      19.533846,
      11.176160,
      0.435981,
      14.419291,
      NULL,
      0.569591,
      NULL,
      11.522910,
      NULL,
      2.086920,
      NULL,
      NULL,
      0.238363,
      1,
      ' 5- 5-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      264,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1976',
      15.477323,
      ' 0- 0-1996',
      0.799530,
      2,
      ' 6-14-1988',
      48.971940,
      0,
      ' 0-17-1998',
      NULL,
      NULL,
      '11-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 2- 3-1999',
      21.534802,
      15.048588,
      12,
      '10-28-2000',
      0,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


