set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4441',
      '33020401',
      '34400321',
      '14421201',
      '42101414',
      '13123002',
      '22334032',
      NULL,
      '01322113',
      '31213032',
      NULL,
      '02030311',
      '14341433',
      '24000212',
      '24320304',
      '34343243',
      '20043031',
      '14414141',
      '10314220',
      '04434111',
      '34142104',
      NULL,
      '12440140',
      '20104331',
      NULL,
      '03401131',
      NULL,
      '31422233',
      '24341122',
      NULL,
      '24141212',
      NULL,
      '14003432',
      NULL,
      '44333013',
      '13040232',
      '21441222',
      '40333133',
      '30221231',
      NULL,
      '42210340',
      '22230212',
      '11232141',
      '12423430',
      '22011212',
      '102',
      '21',
      NULL,
      NULL,
      '1041402',
      NULL,
      0.294665,
      0,
      NULL,
      '302043',
      1,
      ' 5- 8-1990',
      ' 3-20-1995',
      NULL,
      NULL,
      2.058765,
      0.992051,
      10.543292,
      9,
      NULL,
      9,
      3.373955,
      3.620760,
      17,
      4.965318,
      6.297137,
      8,
      11,
      11.313303,
      13,
      NULL,
      19,
      13,
      40.060862,
      8,
      15.545098,
      14.877987,
      1.776808,
      NULL,
      20.571849,
      54,
      25,
      96,
      25.126798,
      ' 6-11-1990',
      NULL,
      15,
      4.370910,
      10.757407,
      NULL,
      128,
      '11-11-1998',
      3.611146,
      3.483214,
      6.110359,
      3.376705,
      8,
      4.233622,
      0.789152,
      5.150540,
      NULL,
      1,
      1.660213,
      1,
      1,
      NULL,
      0,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-2000',
      5,
      59.586668,
      NULL,
      12.705895,
      NULL,
      4.353518,
      NULL,
      0,
      NULL,
      36.246764,
      1,
      NULL,
      NULL,
      0.408919,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      ' 0- 3-2001',
      84,
      6.970204,
      NULL,
      13,
      46.016604,
      51.119623,
      NULL,
      93.975431,
      48,
      70,
      42.403608,
      55,
      ' 0- 0-1985',
      4.444358,
      15.531241,
      1.934617,
      1.886212,
      56.377291,
      3.985637,
      7.035405,
      '10-19-1982',
      6.995878,
      1,
      ' 3-22-1982',
      2,
      0.132961,
      8,
      13.073925,
      0,
      6,
      2,
      NULL,
      1.951530,
      NULL,
      1,
      NULL,
      0,
      21.657821,
      1.728971,
      NULL,
      NULL,
      0.442940,
      ' 9- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      45.487680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1976',
      17.279303,
      ' 3- 6-2003',
      3,
      NULL,
      ' 6-23-1982',
      49.615344,
      9.702252,
      ' 8-26-1979',
      0,
      8.189279,
      ' 4- 0-1986',
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      48.140372,
      12.827814,
      15,
      ' 3-22-1996',
      NULL,
      260.574016,
      ' 2- 3-1975',
      11.251180,
      NULL,
      10,
      54,
      ' 9-19-1980',
      63.149639,
      1,
      171.522947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


