set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3400',
      '22240144',
      '42124224',
      NULL,
      NULL,
      '22432202',
      '42224202',
      '24422041',
      '03400023',
      '20344203',
      '41014312',
      '44344022',
      '42234321',
      '02421043',
      '13211302',
      '33400112',
      '01400341',
      '33233012',
      '21104101',
      '20104332',
      '14040044',
      '22411020',
      NULL,
      '20141212',
      '11430112',
      NULL,
      '03004302',
      '14212011',
      '31133102',
      '41330414',
      '13323421',
      '04333033',
      '40032214',
      '04114402',
      '24232100',
      '40311010',
      NULL,
      '00110222',
      '23424214',
      '24312313',
      '30113034',
      NULL,
      NULL,
      '43312400',
      '10024404',
      '420',
      '40',
      13.372836,
      6,
      '0012134',
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-2000',
      '11-26-1980',
      52,
      10,
      10,
      NULL,
      10,
      4,
      44,
      10,
      7,
      4.420762,
      6.099464,
      NULL,
      10.337615,
      5.610650,
      22.658786,
      1.451732,
      1,
      7,
      24.837311,
      1,
      NULL,
      0.628636,
      44,
      0,
      NULL,
      37.965517,
      52,
      8.945880,
      NULL,
      NULL,
      57.737712,
      ' 0- 9-2000',
      15.433120,
      35.399799,
      NULL,
      20,
      20,
      NULL,
      ' 4-28-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.298577,
      22,
      9.174768,
      7.672849,
      1,
      0.831016,
      '11-15-1985',
      NULL,
      0,
      77,
      0,
      3,
      NULL,
      NULL,
      1,
      9.795808,
      NULL,
      NULL,
      NULL,
      NULL,
      23.953649,
      NULL,
      15.328003,
      6,
      NULL,
      26.209849,
      42.874923,
      55.909034,
      NULL,
      73.867206,
      32,
      47,
      ' 3- 6-1994',
      1,
      1,
      13.389563,
      NULL,
      44,
      10.674509,
      NULL,
      ' 7-23-1978',
      7,
      10.824809,
      ' 3-18-1979',
      5,
      NULL,
      6,
      6.719025,
      2.443608,
      3.823282,
      0.235421,
      5,
      NULL,
      2.674938,
      8,
      0,
      6.918355,
      13.806607,
      NULL,
      2,
      NULL,
      0.127483,
      '11-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      4,
      ' 0- 6-1999',
      NULL,
      NULL,
      NULL,
      31.321434,
      '11-19-1992',
      28.759671,
      ' 5-16-1984',
      NULL,
      NULL,
      ' 9-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.026338,
      ' 7-29-1993',
      NULL,
      1,
      9.240014,
      ' 8-25-1977',
      9,
      91.043193,
      ' 2-17-1989',
      4.350185,
      18,
      16,
      111,
      ' 8-18-1975',
      65.823997,
      0.455533,
      NULL,
      ' 5-18-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


