set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '2',
      '3',
      '1',
      '2',
      '1',
      '3',
      '4',
      '0',
      '3',
      '2',
      '1',
      NULL,
      '2',
      '0',
      '3',
      NULL,
      NULL,
      '3',
      '4',
      '2',
      '1',
      '1',
      '',
      NULL,
      '',
      NULL,
      NULL,
      '3',
      '0',
      '0',
      '',
      '',
      '2',
      '3',
      '3',
      NULL,
      '2',
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      '3',
      '312',
      '43114214',
      33.108349,
      30,
      '4131021',
      NULL,
      14,
      1,
      NULL,
      '213041',
      0,
      NULL,
      ' 5-23-1990',
      37,
      140,
      8,
      13,
      NULL,
      15,
      31.203141,
      6,
      0,
      2,
      NULL,
      NULL,
      9.033326,
      0,
      NULL,
      1.450935,
      12,
      5,
      NULL,
      8,
      16,
      NULL,
      30,
      5,
      1,
      6,
      59,
      NULL,
      44,
      NULL,
      10,
      ' 7- 9-1975',
      32.481860,
      3,
      19,
      22.941195,
      NULL,
      77.637881,
      ' 9- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      11.562048,
      5,
      NULL,
      7.102798,
      ' 1-22-1988',
      1.947586,
      0,
      72.469944,
      1.345407,
      0.122691,
      NULL,
      NULL,
      0.141260,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1975',
      NULL,
      NULL,
      85,
      92.505747,
      69.194495,
      61,
      30,
      42.258694,
      72.818778,
      5.240411,
      NULL,
      30,
      ' 2-13-1976',
      6,
      NULL,
      2,
      NULL,
      38.023288,
      4,
      3,
      '10- 6-1982',
      3.896106,
      5,
      ' 8-26-1989',
      2,
      2,
      0.225215,
      8,
      10,
      1.380125,
      1.314906,
      NULL,
      1,
      NULL,
      0,
      0.711135,
      3,
      NULL,
      NULL,
      6.476745,
      NULL,
      1.386297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      5.464264,
      ' 8-20-1992',
      NULL,
      NULL,
      NULL,
      28.205427,
      ' 6-15-2000',
      11,
      ' 9-19-1978',
      7,
      3.967128,
      ' 0- 5-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      '10-28-1977',
      56,
      21,
      16.256703,
      ' 8-25-2003',
      2.466723,
      412.423529,
      '11- 9-1990',
      12,
      17,
      3.297136,
      151,
      NULL,
      33.574865,
      0.049928,
      159.433514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


