set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '1',
      '3',
      '0',
      '4',
      '4',
      '2',
      NULL,
      '2',
      '3',
      '1',
      NULL,
      '1',
      '3',
      NULL,
      '3',
      NULL,
      NULL,
      '2',
      '3',
      '1',
      '3',
      '4',
      '',
      NULL,
      NULL,
      '3',
      '2',
      '1',
      NULL,
      '0',
      '',
      '',
      '0',
      '0',
      '3',
      '0',
      '4',
      NULL,
      '3',
      NULL,
      '0',
      '3',
      NULL,
      '303',
      '34102441',
      31,
      NULL,
      '2013232',
      NULL,
      NULL,
      1,
      1,
      NULL,
      5.570482,
      ' 9- 9-2000',
      ' 8- 7-1976',
      20.461290,
      188,
      NULL,
      4,
      2.909983,
      5.433514,
      NULL,
      NULL,
      2.054684,
      5.354067,
      NULL,
      0.752626,
      17.276630,
      NULL,
      NULL,
      NULL,
      5.813818,
      11,
      34.224168,
      3.788405,
      22,
      NULL,
      NULL,
      8,
      1.945676,
      31.815594,
      NULL,
      13.171012,
      4.587755,
      45.025723,
      68,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      11,
      6.835108,
      ' 2- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.491673,
      3.258969,
      3.076917,
      ' 0-28-1983',
      0.341284,
      NULL,
      NULL,
      1.323070,
      NULL,
      13.959385,
      0.209711,
      1.266956,
      1.553526,
      NULL,
      NULL,
      NULL,
      ' 1-10-1988',
      56.361570,
      14.189887,
      60,
      NULL,
      21.900065,
      NULL,
      5.830316,
      48.873782,
      22.190778,
      52,
      26.720581,
      40,
      ' 7-14-1977',
      12.597665,
      6.803626,
      NULL,
      19.967643,
      27.004631,
      0.765014,
      NULL,
      ' 9- 6-1993',
      8.945351,
      3,
      ' 5-12-2001',
      0,
      7.770721,
      6.085209,
      5.312995,
      6,
      0.076069,
      NULL,
      1.959175,
      1.479694,
      18,
      9,
      0.451555,
      3.868562,
      2.801713,
      4,
      7,
      NULL,
      0,
      ' 7- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      ' 9-15-1990',
      30,
      ' 5-22-2000',
      3,
      NULL,
      ' 6- 7-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6,
      ' 1-10-1974',
      9,
      NULL,
      6.158752,
      ' 4-15-1981',
      0.636806,
      341.955505,
      ' 7-21-1985',
      NULL,
      84.589987,
      9,
      0,
      NULL,
      55,
      1.934214,
      113,
      ' 8- 5-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


