set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3375517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '3',
      '3',
      '0',
      '0',
      '3',
      '4',
      NULL,
      '2',
      NULL,
      '1',
      '3',
      '4',
      '4',
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      '',
      '3',
      '',
      NULL,
      '0',
      '2',
      '4',
      '1',
      '',
      NULL,
      '1',
      '3',
      '4',
      '1',
      NULL,
      '2',
      NULL,
      '4',
      '0',
      '3',
      '1',
      '240',
      '24212441',
      NULL,
      14,
      '2241320',
      0,
      NULL,
      NULL,
      0,
      '411332',
      6.039301,
      ' 9-22-1977',
      NULL,
      13.055680,
      104,
      12,
      NULL,
      28.557588,
      19.219059,
      84.033012,
      NULL,
      31.423974,
      11,
      26,
      1,
      NULL,
      24,
      4.452789,
      2.913720,
      6,
      10,
      79.594910,
      12,
      22.429540,
      11.611135,
      52,
      22.186750,
      0,
      109,
      195,
      88.159025,
      182.905017,
      117.200170,
      NULL,
      '10-16-1992',
      NULL,
      59,
      37,
      13,
      22.673862,
      36.359125,
      ' 6-11-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.412698,
      5.701241,
      NULL,
      ' 3- 3-1985',
      0,
      NULL,
      NULL,
      0,
      2,
      93,
      1.332621,
      0.113931,
      69,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1999',
      NULL,
      NULL,
      136.868505,
      22.925531,
      43.502224,
      67.570861,
      114,
      NULL,
      NULL,
      34,
      22,
      59,
      '10- 8-1978',
      20,
      NULL,
      15.109180,
      38,
      77.689524,
      51.500315,
      NULL,
      '11-29-1997',
      5,
      NULL,
      ' 8- 4-1999',
      9.774106,
      12.904386,
      17.569667,
      9.649276,
      25,
      NULL,
      NULL,
      22,
      0,
      35.882835,
      0.186888,
      3,
      0,
      11,
      1,
      0,
      0.479643,
      2,
      ' 6- 6-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      98.074164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.387214,
      NULL,
      1.679827,
      ' 4- 5-1981',
      21,
      7.501306,
      ' 8-11-1998',
      123,
      47.069222,
      ' 3-21-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      26,
      ' 1-21-1985',
      1,
      37,
      50,
      ' 6-10-1998',
      0,
      54,
      ' 5-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


