set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6516689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2431',
      '10001331',
      '41311304',
      '30313124',
      '21123004',
      NULL,
      '13000423',
      '42443313',
      '04422020',
      '01201234',
      '31423401',
      '40111012',
      '44101003',
      '14232012',
      '22223203',
      '01324143',
      '00232424',
      '20321011',
      '04134233',
      '31322020',
      '13033334',
      '01314434',
      '21024401',
      '20403402',
      '23410211',
      '31111004',
      '22114243',
      NULL,
      '22340413',
      NULL,
      '41303010',
      NULL,
      '40200234',
      '32043404',
      '44240201',
      '32240223',
      '23001204',
      NULL,
      NULL,
      '32114111',
      '33441110',
      '11411041',
      '30220014',
      '33034011',
      '32412324',
      '301',
      '33',
      0.499648,
      NULL,
      '2013122',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      ' 3-16-1998',
      98.375053,
      61,
      NULL,
      15,
      21,
      2,
      49,
      7,
      10.580723,
      11,
      6,
      18,
      13,
      11.827250,
      4,
      20.098061,
      20.133099,
      NULL,
      63,
      20.234024,
      31,
      3,
      47.667923,
      NULL,
      1,
      76.996982,
      27.373717,
      11,
      165,
      61,
      124.920776,
      NULL,
      NULL,
      NULL,
      17.138794,
      16.717360,
      80.865747,
      48,
      ' 7-19-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.525479,
      2,
      13,
      NULL,
      7.248454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.970507,
      0,
      168,
      NULL,
      7,
      19.131582,
      NULL,
      NULL,
      NULL,
      '10-28-1988',
      7,
      40.613937,
      95,
      97,
      53,
      121,
      59.601766,
      72,
      4.091835,
      87,
      39.263035,
      82,
      ' 0- 7-1977',
      25.383300,
      32.789551,
      23.831290,
      1.784710,
      59,
      116,
      NULL,
      ' 9-13-1993',
      5.046432,
      NULL,
      ' 0- 1-1982',
      9,
      NULL,
      14,
      3,
      4.106355,
      0,
      NULL,
      2.765483,
      1,
      NULL,
      2,
      5.190598,
      NULL,
      12,
      4.963816,
      NULL,
      2.977563,
      0,
      ' 1-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      NULL,
      ' 5-16-1997',
      NULL,
      NULL,
      NULL,
      10,
      '11-19-1976',
      18,
      ' 9-18-1988',
      1,
      8,
      ' 3- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.796457,
      ' 4-26-1990',
      NULL,
      9,
      NULL,
      '10- 1-1984',
      NULL,
      93.486879,
      ' 3-16-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


