set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9729939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '0',
      '3',
      '3',
      '2',
      '3',
      '4',
      '0',
      NULL,
      '4',
      '0',
      '0',
      '0',
      '3',
      '4',
      '3',
      '2',
      '1',
      '3',
      NULL,
      '0',
      '2',
      '',
      '0',
      '',
      '0',
      '0',
      '4',
      '4',
      NULL,
      '',
      '',
      '4',
      NULL,
      '3',
      '2',
      '1',
      NULL,
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '013',
      '43143433',
      49,
      50,
      '0221111',
      NULL,
      0.537899,
      2,
      NULL,
      '333334',
      5,
      ' 3- 4-1997',
      NULL,
      92.097824,
      NULL,
      NULL,
      10,
      2,
      7,
      NULL,
      9.656122,
      5,
      NULL,
      NULL,
      0,
      12,
      9.873580,
      9,
      8.301949,
      NULL,
      11.950427,
      NULL,
      NULL,
      NULL,
      11.342079,
      57.220735,
      13.851642,
      1,
      64.252802,
      NULL,
      31.949589,
      142.645023,
      62.431192,
      102.700271,
      ' 3-16-1981',
      48.999169,
      33.820583,
      1.074736,
      15,
      21.165654,
      137,
      ' 4-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.857492,
      6.422907,
      10.876096,
      2,
      ' 2- 5-1980',
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.263282,
      0.366835,
      13,
      NULL,
      NULL,
      NULL,
      ' 4-12-1989',
      28,
      71,
      6.196212,
      46,
      56,
      67.302966,
      0,
      NULL,
      66.457284,
      20.837857,
      84,
      21,
      ' 3-16-1984',
      NULL,
      3.149583,
      7,
      NULL,
      17.082502,
      0,
      3,
      ' 7- 6-1990',
      11,
      NULL,
      NULL,
      7.274723,
      NULL,
      19,
      21,
      9.959217,
      6,
      1.240190,
      19.530490,
      0.380805,
      0,
      0.753153,
      1,
      10.552536,
      NULL,
      3,
      0,
      0.070375,
      1.823269,
      ' 5-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      126.014908,
      6,
      ' 2- 0-1997',
      NULL,
      NULL,
      NULL,
      9,
      ' 0-25-1979',
      24.008354,
      '10-29-2002',
      4.032244,
      6,
      ' 4- 7-1975',
      61,
      26.364104,
      ' 2- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      14,
      ' 5-25-2003',
      NULL,
      3.861003,
      2.313876,
      '10-29-1976',
      0,
      93,
      ' 1-22-1995',
      10.001029,
      88.316928,
      15,
      NULL,
      ' 0-26-1975',
      23.270695,
      1.974733,
      NULL,
      ' 9- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


