set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9729939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '4',
      '0',
      '1',
      '0',
      '3',
      NULL,
      '0',
      '2',
      '1',
      '2',
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      '',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      '',
      '',
      '2',
      NULL,
      '2',
      '0',
      '1',
      '0',
      '2',
      '1',
      '2',
      NULL,
      '4',
      NULL,
      NULL,
      52,
      56,
      '3310231',
      0,
      3.693656,
      3,
      NULL,
      '012320',
      6,
      NULL,
      ' 7- 2-2003',
      125.731792,
      20.852009,
      2,
      3.922672,
      NULL,
      17.872054,
      19,
      1.271088,
      29,
      NULL,
      NULL,
      11.722524,
      23.605657,
      NULL,
      29,
      13.956631,
      9,
      3,
      23,
      NULL,
      45,
      6,
      NULL,
      3,
      NULL,
      32.902176,
      103,
      47.004006,
      57,
      165,
      NULL,
      ' 8-24-2001',
      22.568779,
      NULL,
      24.975919,
      15.672034,
      NULL,
      49,
      ' 0-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104.729776,
      10.341152,
      7.584849,
      6.788364,
      8,
      NULL,
      ' 1-12-2002',
      1.277006,
      NULL,
      72,
      0.437565,
      0.242948,
      104.689949,
      NULL,
      0.421549,
      25,
      NULL,
      NULL,
      NULL,
      '10- 7-1980',
      NULL,
      27,
      74,
      62.905666,
      3.108968,
      27.019350,
      113.141456,
      NULL,
      15,
      93.662836,
      63.370849,
      63.128665,
      ' 4-18-1979',
      4,
      11,
      NULL,
      5.503622,
      4,
      28,
      NULL,
      NULL,
      4,
      NULL,
      '11-11-1980',
      1.944482,
      8,
      9.265694,
      NULL,
      0.958779,
      1,
      1,
      7.552993,
      0.808254,
      NULL,
      1,
      NULL,
      8.148698,
      13.286486,
      0.656951,
      0.747258,
      1,
      1.912270,
      ' 5- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      119.395389,
      9,
      ' 1-12-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 7-2000',
      18,
      ' 7-22-1980',
      3.232249,
      NULL,
      NULL,
      NULL,
      60.540846,
      '10-11-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      16.042858,
      ' 4-29-1976',
      55.177028,
      18.880915,
      NULL,
      ' 4-15-1996',
      1.345431,
      127,
      ' 9-20-1980',
      8.029287,
      69,
      23.011827,
      15.390480,
      ' 9-11-1994',
      12.982515,
      0,
      NULL,
      ' 3- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


