set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3240',
      '14343424',
      NULL,
      '14113344',
      '22144242',
      '23141000',
      '41011141',
      '42031021',
      '11344021',
      '23401132',
      '33211213',
      NULL,
      NULL,
      '30322023',
      '32013202',
      '10220114',
      '31233134',
      NULL,
      NULL,
      '24434114',
      '22210304',
      '21431041',
      '23443443',
      NULL,
      NULL,
      '32011143',
      '23323321',
      NULL,
      '41200414',
      NULL,
      '41332111',
      '30411112',
      '01342234',
      '03240430',
      '43243313',
      '41220400',
      '32200222',
      '41424014',
      '23433411',
      NULL,
      '21102204',
      '33113014',
      '22020244',
      NULL,
      '14424020',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      '133013',
      3,
      ' 6-16-2001',
      ' 7-14-1982',
      36.384905,
      NULL,
      29,
      NULL,
      1.953740,
      8.492833,
      49,
      NULL,
      6.059889,
      7,
      34.659937,
      1,
      2.693392,
      5,
      22,
      10.130139,
      21,
      13,
      NULL,
      13.091881,
      45,
      7,
      2.595917,
      7.286896,
      NULL,
      83.042803,
      149,
      35.503581,
      NULL,
      90.510067,
      130.300340,
      ' 4-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012902,
      0.658454,
      0.106251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.158658,
      0.479530,
      NULL,
      3.856062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-23-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-27-1978',
      29,
      84.086702,
      93.654423,
      70,
      26.589752,
      108.065260,
      73.705828,
      26,
      24,
      NULL,
      49.839448,
      NULL,
      ' 5-15-1983',
      20.692635,
      7.237762,
      11,
      6.265483,
      NULL,
      33.783797,
      NULL,
      ' 5-18-1994',
      2.483290,
      35,
      ' 0- 5-1978',
      1.201233,
      NULL,
      4,
      NULL,
      13.670417,
      6.383978,
      NULL,
      10,
      NULL,
      38.807821,
      0.747474,
      1.863706,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.672038,
      3.421358,
      5,
      NULL,
      0.465111,
      82,
      ' 3- 0-1979',
      11.336676,
      59.537701,
      2.657806,
      3,
      ' 0-22-1988',
      27.657360,
      1.335035,
      142.322759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      40.582583,
      96.271330,
      37,
      65.461881,
      55.286882,
      NULL,
      18,
      12,
      11.913874,
      NULL,
      3,
      NULL,
      48,
      1.149891,
      6.723334,
      19,
      NULL,
      1.775915,
      108.657754,
      2.526710,
      7.915059,
      178.565052,
      1.261143,
      NULL,
      NULL,
      0,
      6.904248,
      1.926046,
      0,
      NULL,
      1.490004,
      NULL,
      1.332376,
      76.693122,
      11,
      71,
      9,
      87,
      NULL,
      1,
      0,
      NULL,
      1.162393,
      2,
      1.873585,
      1.931519,
      0.024569,
      53.454740,
      0,
      51,
      1,
      0.750534,
      NULL,
      13,
      6,
      24,
      13,
      7,
      24,
      97.230852,
      2,
      3,
      NULL,
      7.818184,
      0.350815,
      0,
      0.502046,
      NULL,
      82.563758,
      ' 5-11-1992',
      ' 0- 1-1988',
      NULL,
      ' 6-13-1975',
      '10- 2-1979',
      ' 5-22-1974',
      ' 4- 2-1992',
      NULL);
commit;
end;
/


