set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4422',
      '43301113',
      '14220424',
      '20144020',
      NULL,
      '42240014',
      '10000104',
      NULL,
      '22331334',
      '33340344',
      '00041123',
      '42411303',
      '20212331',
      '04343443',
      '41023002',
      '10314404',
      NULL,
      '14212130',
      '21041224',
      NULL,
      '31110103',
      '02034201',
      '02323131',
      '13221103',
      '42244434',
      '31421210',
      '04244321',
      '10041213',
      '01210334',
      '20241311',
      '40314323',
      '40240241',
      '31420040',
      NULL,
      '10314043',
      '00422012',
      '30402344',
      NULL,
      '34411243',
      '23021023',
      NULL,
      '04014041',
      '30423130',
      '31310330',
      '42100030',
      NULL,
      '32',
      NULL,
      NULL,
      '4112342',
      NULL,
      0.505676,
      2,
      NULL,
      '442112',
      3,
      ' 6- 7-1981',
      NULL,
      1,
      NULL,
      19,
      1,
      14,
      13,
      3,
      6,
      22,
      NULL,
      21.187338,
      4,
      37.620536,
      NULL,
      6.364131,
      8.700106,
      23,
      5,
      43.850499,
      15,
      17.447759,
      10.863044,
      NULL,
      13,
      1.037266,
      19.621051,
      85.029546,
      NULL,
      NULL,
      73,
      1.714624,
      ' 6- 8-1985',
      44,
      16,
      27,
      NULL,
      173,
      37,
      '10-14-1985',
      1.209024,
      0.568932,
      NULL,
      NULL,
      7.160762,
      0.600906,
      NULL,
      0,
      0.069518,
      1.904434,
      0,
      1,
      NULL,
      0,
      NULL,
      1.597550,
      NULL,
      0,
      1,
      0.131165,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1999',
      87,
      NULL,
      13.445978,
      9.441763,
      3.534666,
      5,
      '11-28-2003',
      1,
      2,
      43,
      3.856258,
      NULL,
      NULL,
      1.528455,
      1.980349,
      NULL,
      NULL,
      1.174138,
      5.529532,
      ' 0- 0-1999',
      65,
      NULL,
      81,
      89,
      86,
      21.171848,
      30.042282,
      72.992982,
      NULL,
      64,
      76.596275,
      NULL,
      ' 1- 4-1999',
      8,
      13.195402,
      NULL,
      1,
      37,
      38.999631,
      NULL,
      '11- 0-1999',
      2.398044,
      11.771817,
      NULL,
      13.689998,
      15.833762,
      14,
      3,
      14.678103,
      0,
      NULL,
      16.563474,
      1.399724,
      73,
      0,
      0,
      NULL,
      17,
      NULL,
      0,
      NULL,
      1,
      ' 6-25-1994',
      0,
      0,
      NULL,
      ' 9-16-1976',
      30.611291,
      7,
      ' 5-11-1980',
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      NULL,
      ' 1-15-1995',
      11,
      10.570806,
      NULL,
      110,
      NULL,
      ' 4-15-1996',
      7.780156,
      9.537528,
      ' 3-27-2003',
      1,
      16.140363,
      NULL,
      NULL,
      1,
      19.144828,
      ' 5-28-1980',
      NULL,
      21.432495,
      24,
      ' 0-23-1978',
      3.936112,
      NULL,
      ' 8- 8-1983',
      7,
      NULL,
      13,
      51,
      ' 4-17-1985',
      71,
      NULL,
      2.135060,
      ' 6-14-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.149346);
commit;
end;
/


