set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2432',
      NULL,
      NULL,
      '44443032',
      '22320204',
      '03033400',
      '31441410',
      NULL,
      '03031043',
      '30012302',
      '41201024',
      '22331421',
      '22420343',
      NULL,
      '33314310',
      '11232313',
      '43443223',
      '33133320',
      '22431001',
      '22331243',
      '03311133',
      '30223010',
      '03034104',
      '33401200',
      '03433312',
      '32400311',
      '10232013',
      '02034004',
      '41310230',
      '02044422',
      '23440422',
      '14111131',
      '33330330',
      '14340442',
      '13001210',
      '02432443',
      '00040411',
      NULL,
      '43104124',
      NULL,
      '04232234',
      '02410042',
      '43143213',
      NULL,
      '41432333',
      '313',
      '33',
      NULL,
      NULL,
      NULL,
      0.735344,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 7-25-1990',
      ' 8-11-1983',
      5,
      NULL,
      11.210859,
      13,
      12,
      NULL,
      46.039428,
      3,
      17.068414,
      1.020911,
      31,
      NULL,
      8.157396,
      NULL,
      3,
      21,
      8,
      29.335913,
      21.068065,
      3.532152,
      0.192710,
      0,
      70,
      11,
      0.036810,
      55,
      34,
      NULL,
      34.322144,
      NULL,
      NULL,
      ' 6-24-2001',
      NULL,
      22,
      0.991959,
      NULL,
      48,
      51.979785,
      ' 9- 3-1987',
      0.929034,
      0,
      1,
      1.075508,
      1.859967,
      1,
      2,
      1.677934,
      1.414188,
      0.306684,
      1.822464,
      1,
      0.884241,
      1,
      1.033533,
      NULL,
      1.310948,
      NULL,
      0.360097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-1985',
      24,
      24.651951,
      2.292782,
      1,
      12,
      5.229507,
      ' 5- 3-1978',
      0,
      3.466010,
      78.400753,
      0,
      2.155535,
      43,
      1.372117,
      3,
      32.964933,
      NULL,
      NULL,
      NULL,
      ' 5-11-1994',
      NULL,
      4.786813,
      19.783052,
      NULL,
      NULL,
      64,
      54,
      67,
      NULL,
      29,
      30,
      40.672567,
      ' 8- 7-1991',
      10.033296,
      NULL,
      7,
      51.610608,
      25,
      15.728462,
      6,
      NULL,
      NULL,
      NULL,
      '11-26-1996',
      3,
      11.096811,
      11,
      15,
      17.309384,
      NULL,
      1.451884,
      19,
      NULL,
      109,
      NULL,
      0,
      21.587056,
      NULL,
      5.674504,
      1,
      3,
      NULL,
      '10- 2-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-19-1977',
      NULL,
      NULL,
      NULL,
      28,
      ' 8-27-1995',
      NULL,
      ' 6-15-1983',
      9.742208,
      16,
      ' 5-17-1983',
      52.953733,
      65,
      ' 4- 7-1977',
      4.744785,
      5.967460,
      ' 7- 9-1999',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      ' 9-19-1981',
      48,
      25.366527,
      30.616638,
      ' 2-25-1991',
      NULL,
      NULL,
      NULL,
      12.503601,
      9.599866,
      7.006380,
      46,
      ' 0- 7-1979',
      69.961838,
      0,
      NULL,
      ' 9- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


