set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '2',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      '0',
      '2',
      '0',
      NULL,
      NULL,
      '0',
      '2',
      '2',
      '4',
      '3',
      '3',
      '1',
      '',
      '4',
      '',
      NULL,
      '1',
      '0',
      '2',
      '2',
      '',
      '',
      '3',
      '0',
      '3',
      '1',
      '2',
      '1',
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '323',
      '44420003',
      14,
      28,
      NULL,
      NULL,
      8.713715,
      2,
      NULL,
      '141443',
      NULL,
      ' 6-27-1986',
      ' 5-27-1999',
      104.871730,
      NULL,
      NULL,
      0,
      11.485913,
      14.547561,
      26.350095,
      NULL,
      2,
      NULL,
      NULL,
      6.031907,
      11.659570,
      7.784141,
      NULL,
      2.831118,
      24.919352,
      3.682039,
      26,
      7,
      27,
      7.428492,
      31,
      0,
      0.165590,
      55,
      141.546964,
      77,
      NULL,
      101.080043,
      151.484311,
      ' 0-25-1978',
      26,
      NULL,
      6,
      12,
      112.760724,
      NULL,
      '10-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      18.343428,
      22,
      8,
      3.895457,
      2.160080,
      NULL,
      NULL,
      2.705476,
      110,
      0.686607,
      1.448104,
      NULL,
      NULL,
      1,
      62.213637,
      NULL,
      NULL,
      NULL,
      ' 7-12-1988',
      55,
      17.183471,
      32.704110,
      1,
      55.617524,
      29,
      NULL,
      63,
      83.051789,
      70.921938,
      16,
      54.140171,
      ' 1-23-1993',
      2.787553,
      11.536728,
      7.022913,
      24,
      NULL,
      1.164188,
      3.381376,
      ' 1- 0-1984',
      2,
      NULL,
      ' 1- 0-2001',
      0.441701,
      21,
      19,
      1.441116,
      8,
      1.224809,
      0,
      2.804464,
      1,
      43,
      NULL,
      1,
      NULL,
      11.429991,
      1,
      1,
      1,
      1,
      ' 9-21-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      92.614369,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      ' 3- 5-1977',
      20.923944,
      ' 7-25-1981',
      3.168909,
      NULL,
      ' 5- 7-1975',
      109.505887,
      NULL,
      ' 6- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      30,
      ' 9-15-1992',
      5.387965,
      16.037037,
      8.507897,
      ' 6-13-1979',
      1,
      40.799688,
      ' 5-24-1977',
      NULL,
      9.827847,
      0.912180,
      11,
      NULL,
      7.805014,
      1,
      93.355119,
      ' 9-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


