set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3222',
      '23224343',
      '32123333',
      '23412221',
      '42411343',
      NULL,
      '12030013',
      '14033000',
      '12441042',
      '41243032',
      '41321104',
      '30213304',
      '41401142',
      '14333401',
      '13003202',
      '01131301',
      NULL,
      NULL,
      NULL,
      NULL,
      '43242003',
      '40314431',
      '44111242',
      '34022444',
      '34141304',
      NULL,
      '32012123',
      NULL,
      '12101220',
      '22231213',
      '12301423',
      '32231323',
      '21304233',
      '33312040',
      '14010224',
      '03303232',
      '20010333',
      '34411201',
      '02221231',
      '12431432',
      '01022421',
      '44224000',
      NULL,
      '30104232',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.509740,
      0.656758,
      0,
      NULL,
      '324414',
      3,
      ' 8- 2-1994',
      ' 5-27-1982',
      51.908588,
      NULL,
      21.609862,
      15.881424,
      12,
      14.137543,
      109,
      31,
      23.142604,
      2,
      NULL,
      6,
      16,
      7,
      27,
      13.185678,
      32.407760,
      NULL,
      69.443642,
      11,
      66,
      NULL,
      86,
      17,
      NULL,
      118.169985,
      235,
      106,
      34,
      80.293538,
      172,
      '10-16-1985',
      NULL,
      16,
      10.227588,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1995',
      NULL,
      0,
      0.126282,
      3.959307,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.567251,
      0,
      1,
      3.434848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-13-2000',
      33.958919,
      39.241859,
      111.739945,
      NULL,
      NULL,
      109.739423,
      NULL,
      61,
      1,
      57,
      NULL,
      27,
      ' 4-10-1981',
      NULL,
      2.732490,
      4,
      57,
      NULL,
      13.113083,
      3,
      NULL,
      29,
      11,
      NULL,
      NULL,
      7.969448,
      9.884785,
      14,
      19.150040,
      2,
      NULL,
      22,
      NULL,
      64,
      NULL,
      0,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.070881,
      NULL,
      44.975009,
      ' 3- 0-1982',
      NULL,
      NULL,
      ' 1-19-2003',
      NULL,
      NULL,
      20,
      5.012296,
      ' 2-10-1993',
      NULL,
      NULL,
      31.416564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.644992,
      87,
      NULL,
      NULL,
      44,
      7,
      2.184340,
      NULL,
      7.517256,
      NULL,
      NULL,
      NULL,
      0.110007,
      16,
      1.634489,
      1,
      80,
      1.416630,
      3,
      NULL,
      5.781286,
      1,
      60.306520,
      NULL,
      21.368584,
      NULL,
      NULL,
      NULL,
      0.599623,
      0.605596,
      0.886731,
      1,
      1.751802,
      0.216250,
      NULL,
      NULL,
      NULL,
      10.586699,
      NULL,
      NULL,
      1.816415,
      0.102501,
      NULL,
      1.899642,
      NULL,
      1,
      19,
      1,
      NULL,
      NULL,
      NULL,
      1.078212,
      NULL,
      NULL,
      34.428653,
      2.594153,
      36.763213,
      NULL,
      NULL,
      NULL,
      NULL,
      18.310465,
      0.886889,
      1.971060,
      1,
      NULL,
      NULL,
      0,
      1.323542,
      NULL,
      ' 1-22-1992',
      ' 6-13-1985',
      ' 8-17-1997',
      ' 3-21-1986',
      NULL,
      ' 2-18-2002',
      ' 5- 9-1999',
      NULL);
commit;
end;
/


