set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3104',
      '41012402',
      NULL,
      '01411302',
      NULL,
      NULL,
      NULL,
      '01444224',
      '32341443',
      '11242113',
      '00424433',
      '21011030',
      '10233130',
      '44103203',
      '23202134',
      '03111213',
      '34433041',
      '34400440',
      '24102031',
      '43302230',
      '31143242',
      '22200224',
      NULL,
      '41303432',
      '31302142',
      '44112230',
      '41124104',
      '44204132',
      '11241214',
      NULL,
      '02124102',
      NULL,
      '24411313',
      '23332214',
      '10244114',
      '01131140',
      '43112101',
      '44420113',
      '03122324',
      '01104444',
      '12421234',
      NULL,
      '02111224',
      '42241002',
      '30420102',
      '030',
      '41',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      '112242',
      5,
      ' 6-18-1981',
      NULL,
      10.112701,
      NULL,
      7,
      10,
      29,
      21.405196,
      73,
      NULL,
      13,
      2,
      18.892656,
      14.259420,
      14.025674,
      NULL,
      8,
      13,
      NULL,
      8.260993,
      31.303683,
      6.572378,
      23.670392,
      3,
      14,
      1,
      0.692092,
      39,
      98,
      35.350741,
      4,
      166.364097,
      NULL,
      ' 1-11-1998',
      65.357691,
      58.919800,
      22,
      5,
      91.887727,
      25.341030,
      ' 9- 8-1987',
      3,
      NULL,
      0,
      3.648202,
      1.131958,
      0,
      2,
      0.790708,
      NULL,
      1,
      NULL,
      1,
      1.397700,
      5.763273,
      1.769239,
      0.873561,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      43.022103,
      9,
      10,
      31.708327,
      1.607990,
      ' 6- 6-1996',
      0,
      1,
      142.863548,
      NULL,
      3,
      10.672266,
      1,
      1,
      67,
      1,
      NULL,
      NULL,
      ' 5-12-1979',
      64,
      104,
      12,
      10.530591,
      36.249913,
      NULL,
      52,
      NULL,
      47.714544,
      17,
      6,
      27.435204,
      NULL,
      10.542618,
      NULL,
      9.757509,
      16,
      44.930010,
      79,
      3.796177,
      ' 7- 1-1979',
      NULL,
      4.154383,
      ' 0-29-1998',
      NULL,
      12,
      19,
      12,
      24,
      4,
      3,
      3,
      NULL,
      63,
      2.666028,
      3,
      NULL,
      5,
      7,
      3.807217,
      NULL,
      2.595990,
      '10-13-1987',
      6,
      NULL,
      0.891968,
      ' 2- 9-1995',
      110,
      37.284329,
      ' 0-29-1983',
      NULL,
      NULL,
      NULL,
      11,
      '11- 7-1989',
      5,
      ' 4- 6-1998',
      15,
      4,
      ' 5- 8-1979',
      11.154534,
      NULL,
      '10- 4-1992',
      8,
      NULL,
      ' 4-29-1976',
      NULL,
      1,
      NULL,
      1,
      0,
      27,
      ' 1-24-1991',
      42.759768,
      3.838658,
      0,
      ' 4-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


