set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3210',
      '41211433',
      '12133411',
      '30333422',
      '01121022',
      '42014443',
      '12413333',
      '04304321',
      '40004341',
      '43403410',
      '30233402',
      '13202243',
      '31010344',
      '04242122',
      '02132231',
      '13132410',
      '43311422',
      '44310041',
      NULL,
      '00410231',
      NULL,
      NULL,
      '13144204',
      NULL,
      '10011032',
      '23104142',
      '23010301',
      '44431300',
      '00133000',
      NULL,
      '00221011',
      '32044044',
      '24133124',
      '02024143',
      NULL,
      '12004021',
      NULL,
      '14044142',
      NULL,
      '33003222',
      NULL,
      '00401030',
      '30043001',
      '10414421',
      '03410304',
      NULL,
      '20',
      26,
      NULL,
      '2433234',
      2,
      1.470356,
      0,
      NULL,
      '233131',
      0,
      ' 5-22-1983',
      '11-10-1983',
      13,
      28.452388,
      45,
      18,
      3,
      NULL,
      46,
      NULL,
      10,
      NULL,
      17,
      10,
      29,
      NULL,
      5,
      2.409382,
      NULL,
      8.384568,
      NULL,
      2.386162,
      NULL,
      6.786540,
      56.375414,
      9,
      0,
      78.402661,
      64.516600,
      47,
      93.815101,
      14.814747,
      147.614114,
      ' 6-26-1986',
      44,
      15.979935,
      15,
      22.405629,
      22.530508,
      71,
      ' 0-21-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      30.898830,
      NULL,
      18.083679,
      1.746233,
      NULL,
      0.173973,
      0.134235,
      215.232655,
      1,
      3.539484,
      35,
      1,
      1,
      5,
      NULL,
      NULL,
      NULL,
      ' 6-25-2002',
      4,
      30.994008,
      12,
      36,
      4.619137,
      5,
      33,
      38,
      NULL,
      17.094004,
      15,
      49,
      ' 4-18-1977',
      NULL,
      16.003109,
      14,
      39,
      21.309114,
      76.724563,
      0,
      ' 4-24-1979',
      0,
      3.990072,
      NULL,
      0,
      NULL,
      5,
      14,
      2,
      4,
      1,
      6,
      NULL,
      51.267480,
      15.707274,
      0,
      NULL,
      20,
      8.954722,
      1.833589,
      0,
      NULL,
      ' 9- 6-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      22.739987,
      ' 3-24-1978',
      NULL,
      NULL,
      NULL,
      17.115771,
      ' 6-17-1995',
      19.664083,
      '10- 0-1992',
      7.374434,
      8.771991,
      ' 5-18-1974',
      42,
      NULL,
      '11-23-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      12.092823,
      ' 2-17-2002',
      49,
      16.204816,
      21.455892,
      ' 5- 4-1990',
      0,
      131.033803,
      ' 9-12-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


