set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1441',
      '32240410',
      '03303311',
      NULL,
      '24141040',
      '44020044',
      '32142004',
      '03214234',
      NULL,
      '33430222',
      '00232000',
      '13131100',
      '40330342',
      NULL,
      '33413204',
      NULL,
      '30002112',
      '02034121',
      '12043341',
      '11314202',
      '04023301',
      '20333024',
      '32304003',
      '22311442',
      '03144142',
      '44203041',
      '24344214',
      '04142121',
      '22430140',
      '32420302',
      '21432344',
      '20333023',
      NULL,
      '02242034',
      '30342010',
      NULL,
      '00402313',
      '20032400',
      NULL,
      '40401314',
      '21004033',
      '32110011',
      '40034322',
      '40311330',
      '12021012',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      ' 4-24-1989',
      NULL,
      63,
      NULL,
      14,
      NULL,
      31.595556,
      20,
      88.248101,
      4.408527,
      0.365372,
      1.261024,
      NULL,
      5.842980,
      16.956581,
      2.609002,
      12.634849,
      2,
      NULL,
      6.872995,
      3.238020,
      8,
      19.634532,
      9.792403,
      47,
      1,
      NULL,
      23,
      40,
      68.423604,
      13.916251,
      181,
      139,
      ' 4-27-1985',
      NULL,
      26.112114,
      NULL,
      29.875784,
      NULL,
      NULL,
      '11-14-1974',
      1.521437,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070798,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1975',
      43,
      99.417384,
      NULL,
      NULL,
      24,
      10.973978,
      40.543387,
      89.947154,
      56,
      33,
      57,
      87.208873,
      ' 3- 5-1981',
      6.179723,
      15,
      NULL,
      3.962879,
      27.037278,
      58,
      5,
      ' 9- 9-1982',
      0,
      NULL,
      ' 4-13-1987',
      11,
      20.565397,
      1.632099,
      12,
      NULL,
      4.605221,
      NULL,
      17.739737,
      NULL,
      11,
      0.133241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.316855,
      NULL,
      NULL,
      ' 7-10-2000',
      2,
      105.560263,
      ' 8-10-1992',
      17.444463,
      161.542161,
      17,
      10,
      NULL,
      64,
      1.358797,
      124,
      ' 1- 2-1988',
      NULL,
      NULL,
      NULL,
      64,
      74.125570,
      1.210547,
      102,
      NULL,
      51,
      NULL,
      13.054923,
      NULL,
      8,
      12.779915,
      39,
      1.903531,
      0.347799,
      18,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.745048,
      0,
      66,
      NULL,
      16,
      87.919478,
      0.870881,
      NULL,
      3,
      2,
      NULL,
      2,
      1.224527,
      NULL,
      NULL,
      110,
      86,
      NULL,
      NULL,
      2.440829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014808,
      NULL,
      NULL,
      3,
      66.628417,
      15,
      2.151272,
      20.561796,
      NULL,
      83,
      15.191991,
      60.750561,
      17.543041,
      3,
      1,
      1.416550,
      NULL,
      0,
      0.695884,
      0.360853,
      3.400639,
      ' 7- 3-2002',
      NULL,
      NULL,
      NULL,
      ' 6- 9-1974',
      ' 2- 2-1998',
      ' 1- 8-1997',
      NULL);
commit;
end;
/


