set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4112',
      '43243402',
      '13310224',
      '00321314',
      '43024114',
      '32104420',
      '21342423',
      '21024034',
      '04010101',
      '13103032',
      '32113120',
      '43300123',
      '32104130',
      '30114111',
      NULL,
      '32420224',
      NULL,
      '22244342',
      '43004241',
      '00330133',
      '04242110',
      NULL,
      '02402100',
      '30041243',
      '43204233',
      '00413022',
      '11224233',
      '41433241',
      '34204334',
      '13310243',
      '22011243',
      '22341040',
      '12132334',
      '14041132',
      NULL,
      '13323202',
      '22332111',
      NULL,
      '23202440',
      '23302231',
      '32123002',
      '30434244',
      '41341212',
      '40131120',
      '10104100',
      '300',
      '32',
      NULL,
      NULL,
      NULL,
      0.457898,
      47.196302,
      2,
      NULL,
      '013023',
      NULL,
      NULL,
      ' 7- 8-2003',
      22,
      NULL,
      12,
      NULL,
      24,
      16.705579,
      81,
      NULL,
      3,
      19,
      5.219893,
      26,
      NULL,
      NULL,
      NULL,
      2.203371,
      17,
      5.172886,
      64,
      8,
      25.110437,
      NULL,
      71.294543,
      23,
      NULL,
      69.052451,
      118.381820,
      NULL,
      78,
      75.490088,
      108,
      ' 3-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111918,
      0.117579,
      NULL,
      0.698150,
      0.517415,
      NULL,
      0.923574,
      0.287350,
      1,
      2.684776,
      NULL,
      0,
      0.411853,
      0,
      1.475221,
      1.510263,
      1.078637,
      1.502090,
      0.102256,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1996',
      29,
      NULL,
      9.937831,
      12.611826,
      NULL,
      3.861799,
      '10-24-1987',
      0.582483,
      0.769129,
      166,
      0.984302,
      0.469314,
      NULL,
      0,
      0,
      NULL,
      0.574285,
      1.699966,
      22,
      ' 9-29-2000',
      26,
      24.996556,
      56.794125,
      21.317046,
      32.037015,
      59,
      20,
      NULL,
      NULL,
      39.802912,
      NULL,
      65,
      ' 9-16-1989',
      NULL,
      8.156208,
      18.703948,
      11,
      42,
      22.316788,
      7,
      ' 6-23-1990',
      31.820361,
      11.034975,
      ' 5-21-1992',
      7,
      12,
      5,
      22,
      9,
      6.270218,
      1,
      NULL,
      0.841945,
      45,
      1,
      47.123710,
      0.672227,
      0,
      NULL,
      1,
      0.108539,
      0,
      ' 2- 1-2000',
      3,
      0.208376,
      1.019791,
      ' 6-17-1975',
      35,
      25.042892,
      ' 9-26-1983',
      NULL,
      NULL,
      NULL,
      6.715779,
      NULL,
      40.796326,
      NULL,
      4,
      17,
      ' 4-20-1976',
      97,
      99.138456,
      ' 5-19-1975',
      0.720982,
      1.731075,
      ' 4-10-1982',
      1.030552,
      1,
      NULL,
      2,
      0,
      8.288998,
      ' 4-16-1992',
      22.771540,
      9.745524,
      7.106501,
      ' 0- 9-1976',
      1,
      NULL,
      ' 2- 3-1998',
      4,
      0,
      NULL,
      NULL,
      ' 8-23-2000',
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


