set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214',
      '44014311',
      NULL,
      '33333124',
      '23113030',
      '41014220',
      NULL,
      '40044144',
      '32443101',
      NULL,
      '40220033',
      '22232332',
      '44434440',
      '11330042',
      NULL,
      '21330300',
      '22304212',
      '00112441',
      '34202103',
      '10433203',
      '32414112',
      '23202401',
      '41420333',
      '21044010',
      NULL,
      '00223303',
      '02032111',
      '22402134',
      '21224240',
      '33320443',
      '41141021',
      '20241024',
      '00334033',
      NULL,
      '32443111',
      '34204300',
      '12033220',
      '00344343',
      '30334022',
      '30044411',
      '42232221',
      '41023324',
      '31212214',
      '13203313',
      '04240332',
      '043',
      NULL,
      NULL,
      NULL,
      '0103432',
      1.579360,
      67,
      2,
      NULL,
      NULL,
      0.340816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      22.843917,
      12,
      19.621212,
      NULL,
      2.570429,
      NULL,
      27,
      12,
      26,
      13.075775,
      2.354529,
      NULL,
      9.264824,
      6.180728,
      15,
      7,
      47.656670,
      NULL,
      94.443562,
      18,
      NULL,
      48,
      83,
      66.364606,
      150,
      34,
      68,
      ' 1-25-1978',
      13.998450,
      13.154001,
      21.013597,
      12.174287,
      NULL,
      NULL,
      NULL,
      0.342038,
      NULL,
      4,
      0.439521,
      NULL,
      1.037913,
      NULL,
      1,
      NULL,
      1,
      1,
      1.912593,
      1.529816,
      1.885471,
      0.318780,
      NULL,
      1,
      0.514433,
      0.431247,
      3.859423,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1995',
      39,
      25,
      NULL,
      38,
      15.809131,
      5.258125,
      ' 3-16-1999',
      1.559724,
      NULL,
      106.055296,
      1,
      0.311434,
      59,
      1.061368,
      NULL,
      13.148236,
      NULL,
      NULL,
      NULL,
      '10-16-1979',
      90,
      6,
      18.605378,
      46,
      3.711379,
      20.904580,
      2.218528,
      45,
      39.952825,
      13,
      NULL,
      53.363316,
      ' 1- 3-1994',
      6.816986,
      9.080940,
      10,
      NULL,
      37.799740,
      25.613219,
      1.646790,
      ' 3- 2-1977',
      5,
      5,
      ' 0-16-1987',
      2,
      18.492535,
      14.693220,
      17.361598,
      17,
      0,
      1.114990,
      10.459203,
      0.365119,
      113.438501,
      1,
      0,
      12,
      NULL,
      1.506026,
      3,
      1,
      1.222189,
      ' 3-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      101.402245,
      7,
      ' 9-18-1985',
      NULL,
      NULL,
      NULL,
      19.713780,
      '11-12-1980',
      NULL,
      NULL,
      14.546214,
      5.595753,
      '10-27-1997',
      NULL,
      42.147119,
      ' 8-27-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.602703,
      NULL,
      37.787047,
      29.835284,
      4.433931,
      ' 3- 5-1978',
      NULL,
      69.772348,
      ' 1-10-1976',
      7.073557,
      48,
      2.157878,
      61,
      ' 4-27-2001',
      15,
      NULL,
      72.327269,
      '10-11-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


