set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      '3',
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1',
      '1',
      '1',
      '3',
      '2',
      '2',
      '0',
      '4',
      '4',
      '4',
      NULL,
      '4',
      '0',
      '4',
      '4',
      '',
      '1',
      '',
      NULL,
      '2',
      '2',
      '1',
      '0',
      '',
      '',
      '2',
      '1',
      '3',
      '3',
      '3',
      '0',
      '2',
      '0',
      '4',
      '1',
      '4',
      NULL,
      '30',
      40.421680,
      14.612780,
      NULL,
      NULL,
      2.145542,
      2,
      NULL,
      '412442',
      0.869345,
      NULL,
      ' 3-26-1992',
      156.696773,
      87.430088,
      21.834986,
      0.963895,
      NULL,
      1,
      61.649495,
      0.404393,
      7.660723,
      7,
      16.320435,
      6.052962,
      20.017872,
      22.951159,
      17,
      2.962170,
      14.289590,
      16,
      24,
      1,
      2.363608,
      12.960584,
      86.435352,
      11.827653,
      0.093865,
      98.482447,
      60,
      NULL,
      NULL,
      104,
      99.786846,
      ' 4-11-1998',
      6.304628,
      17,
      NULL,
      4,
      146,
      8.678431,
      ' 4-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      44.891676,
      19,
      NULL,
      NULL,
      1,
      ' 9-14-1982',
      0,
      1,
      152,
      0.003859,
      2.687250,
      16.250149,
      0.916323,
      0,
      38,
      NULL,
      NULL,
      NULL,
      '10- 8-1997',
      50.965562,
      NULL,
      26.022180,
      NULL,
      53.555569,
      25.654183,
      20,
      37,
      5.179262,
      1,
      53.138894,
      44.154050,
      NULL,
      9,
      18,
      3,
      33.941337,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      ' 8- 1-2003',
      12.135388,
      18.685371,
      2,
      4.106943,
      8.874240,
      11,
      0,
      18.153339,
      NULL,
      NULL,
      6,
      4.670469,
      11.260794,
      NULL,
      1,
      0.129407,
      0,
      0,
      ' 3-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      ' 9-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-16-1989',
      16.954287,
      ' 0-16-1993',
      4.137184,
      NULL,
      ' 5-16-1991',
      NULL,
      NULL,
      ' 9-19-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.300020,
      ' 6-13-1987',
      20.048814,
      21,
      1.865059,
      ' 9-26-1975',
      1,
      71.223838,
      ' 5-13-1995',
      6.146276,
      NULL,
      NULL,
      68,
      ' 7-15-1991',
      56.216951,
      NULL,
      74.943671,
      ' 6-22-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


