set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '2',
      '2',
      '1',
      '4',
      NULL,
      '3',
      '2',
      '3',
      '0',
      '2',
      '1',
      '3',
      '3',
      '0',
      '1',
      '3',
      '2',
      '0',
      '2',
      NULL,
      '0',
      NULL,
      '',
      '0',
      NULL,
      '0',
      '1',
      '1',
      '0',
      '2',
      '',
      NULL,
      '4',
      '4',
      '1',
      '3',
      '0',
      '0',
      '1',
      '0',
      NULL,
      '4',
      '1',
      '423',
      '41000424',
      62.069845,
      70.961131,
      '4234423',
      2.417201,
      160,
      2,
      1,
      '203413',
      2,
      ' 7-23-1984',
      '10-24-1979',
      NULL,
      NULL,
      16.191332,
      3,
      1,
      6,
      64,
      5,
      3,
      9,
      13.016318,
      5.427712,
      21.132159,
      NULL,
      5.562021,
      5.802641,
      NULL,
      2,
      25,
      0.298184,
      12,
      14.638843,
      44,
      8.489095,
      0.902338,
      56,
      137,
      63.001027,
      NULL,
      85,
      109,
      ' 4-27-2000',
      31,
      NULL,
      36.113757,
      24,
      181,
      217.468183,
      '11-15-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.837196,
      5.998798,
      4,
      1.131184,
      15,
      5,
      ' 3-23-1996',
      0,
      1.983743,
      42,
      0.099399,
      1,
      90.866296,
      0.848595,
      1,
      80.259295,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1989',
      NULL,
      17.390400,
      60.173894,
      16.105115,
      72,
      31.259351,
      17.910546,
      51.819938,
      62.341432,
      24.866237,
      NULL,
      21,
      ' 6-24-1995',
      4.302082,
      15.457258,
      NULL,
      39,
      15,
      24,
      NULL,
      NULL,
      NULL,
      3,
      ' 0-19-1995',
      2.153426,
      NULL,
      21,
      13.321194,
      16,
      2,
      0,
      6,
      1.266524,
      75,
      NULL,
      0,
      23.818190,
      NULL,
      1,
      0.945518,
      NULL,
      0,
      ' 7- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      42.169274,
      ' 3- 3-2001',
      NULL,
      NULL,
      NULL,
      42,
      ' 9-26-2000',
      19.137116,
      ' 4- 2-1980',
      NULL,
      2.176028,
      '11-20-1982',
      57,
      18.381182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      16.095361,
      ' 6- 5-1986',
      9.678281,
      NULL,
      11,
      ' 8-23-1996',
      NULL,
      NULL,
      ' 1-25-1975',
      6.732501,
      3.173623,
      14.428221,
      104,
      ' 9- 9-1991',
      53,
      0.106625,
      67,
      ' 4-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


