set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9634992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0320',
      NULL,
      '41103141',
      '20023233',
      '32424331',
      '21133220',
      NULL,
      '22023104',
      '24301201',
      '41443011',
      NULL,
      NULL,
      '21222220',
      '34101344',
      '20110441',
      NULL,
      '41410213',
      '00043303',
      '11010020',
      '34100404',
      '40112302',
      '13044034',
      '41120123',
      '44204214',
      '11343123',
      NULL,
      '14144013',
      '40421222',
      '30442210',
      '30432240',
      '23413310',
      '00011243',
      '02033031',
      '33301331',
      '00323020',
      '30031313',
      '20331121',
      '21400200',
      '12432102',
      '30234110',
      '11333212',
      '10432300',
      '30130310',
      '01210313',
      '01101300',
      NULL,
      '12',
      33,
      5,
      NULL,
      2,
      0,
      2,
      NULL,
      '313400',
      2,
      ' 8- 0-1980',
      ' 5- 9-1984',
      36,
      75.948700,
      33.218579,
      10.369608,
      22,
      4,
      93,
      9,
      NULL,
      11.993070,
      55,
      25.594786,
      37.423577,
      23.100903,
      NULL,
      12,
      NULL,
      10.599900,
      56.282841,
      3.634115,
      15.740872,
      NULL,
      69,
      2.503046,
      0,
      110.743507,
      NULL,
      NULL,
      66,
      197,
      17.793910,
      ' 3-27-1992',
      27.340231,
      14,
      0.597773,
      17.670806,
      13.554006,
      11.146882,
      '11- 8-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      2.658086,
      5.437648,
      5.182842,
      7.479865,
      3,
      ' 7- 8-1994',
      0,
      0,
      127.170851,
      0,
      NULL,
      87.883893,
      1.285828,
      0,
      41.126632,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      85.033549,
      NULL,
      101,
      61.077285,
      78.064781,
      33.734624,
      85.104333,
      4,
      NULL,
      15,
      NULL,
      41,
      NULL,
      4,
      26.947239,
      23.422605,
      23,
      15,
      ' 5-20-1988',
      5,
      16,
      ' 3-12-2002',
      9,
      NULL,
      17.536897,
      NULL,
      NULL,
      1.385963,
      1.588796,
      12.999633,
      1,
      21.085461,
      1.066182,
      22,
      NULL,
      5.929213,
      0.872612,
      NULL,
      NULL,
      0.627936,
      ' 8-15-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.077518,
      ' 9-28-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1983',
      NULL,
      NULL,
      0.277007,
      NULL,
      ' 3- 2-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      11.896649,
      NULL,
      48.825710,
      10,
      35,
      ' 8-28-1974',
      NULL,
      112,
      ' 7- 1-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


