set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2013',
      NULL,
      '13214444',
      NULL,
      NULL,
      NULL,
      '31212234',
      '22302441',
      '04040111',
      NULL,
      NULL,
      NULL,
      '41244342',
      '01144442',
      '10414203',
      '34222010',
      '02333243',
      '22044133',
      '41232134',
      '02340212',
      '41012314',
      '30410401',
      '10044104',
      '10113003',
      '41221040',
      '44110204',
      NULL,
      '02041002',
      '22420101',
      NULL,
      '43014100',
      '14113142',
      NULL,
      NULL,
      '33410043',
      '44432232',
      '40400212',
      '11211231',
      '32230202',
      '02011203',
      '20133303',
      '14401301',
      '32113400',
      '22443043',
      '22014420',
      '',
      '',
      NULL,
      NULL,
      '3224441',
      1.251199,
      1,
      2,
      NULL,
      '130433',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      6,
      NULL,
      21,
      NULL,
      15,
      2,
      3,
      51.307843,
      NULL,
      NULL,
      25.799192,
      NULL,
      NULL,
      15,
      20.874310,
      70.505172,
      24,
      25.730792,
      8,
      88.177991,
      NULL,
      NULL,
      120,
      31.540554,
      NULL,
      NULL,
      98.857962,
      NULL,
      ' 2- 7-1977',
      NULL,
      35.044579,
      NULL,
      14.747843,
      56,
      100.951101,
      ' 6- 3-1991',
      7,
      1.378549,
      1.603639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.437181,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-22-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 8-1974',
      126.102144,
      49,
      NULL,
      168.739089,
      32,
      22.254988,
      9,
      NULL,
      51.233031,
      57,
      1.971071,
      73,
      NULL,
      NULL,
      13.681673,
      11,
      49.227815,
      0,
      NULL,
      NULL,
      ' 3-21-1989',
      NULL,
      6.837051,
      NULL,
      1,
      5.137124,
      17,
      NULL,
      10.157604,
      NULL,
      NULL,
      NULL,
      NULL,
      36.978816,
      1.433665,
      1,
      1.032936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.804162,
      23.945386,
      ' 3-19-2002',
      1.103414,
      240.641711,
      '11-19-1996',
      9,
      17,
      10.758752,
      37,
      ' 4-25-2002',
      65,
      1.331796,
      23,
      ' 0-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      59.264617,
      1,
      0,
      18,
      NULL,
      NULL,
      119.441815,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.187007,
      1.093601,
      1,
      3,
      0.608616,
      0.661425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.865343,
      1.143272,
      13,
      1,
      NULL,
      3.446244,
      35,
      0.912873,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      16.906100,
      NULL,
      NULL,
      4.447108,
      NULL,
      8,
      4,
      1,
      2,
      1,
      NULL,
      0,
      0.994789,
      NULL,
      NULL,
      NULL,
      ' 1-15-1992',
      ' 7-14-1975',
      ' 1- 7-1976',
      NULL,
      '10- 4-1994',
      NULL);
commit;
end;
/


