set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3374023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      '0',
      '0',
      '3',
      '1',
      '0',
      '2',
      '0',
      NULL,
      '2',
      '3',
      '3',
      '0',
      '1',
      '3',
      '3',
      '0',
      '1',
      '3',
      NULL,
      NULL,
      '',
      '3',
      '1',
      NULL,
      '4',
      NULL,
      '',
      '',
      '4',
      '3',
      '2',
      '2',
      NULL,
      '3',
      '3',
      '3',
      '0',
      '0',
      '4',
      NULL,
      '21032143',
      NULL,
      NULL,
      '2401110',
      2,
      1.903401,
      1,
      0,
      '403230',
      6.119714,
      ' 8-20-1983',
      ' 2- 3-1996',
      41.255235,
      231,
      NULL,
      18.288578,
      27,
      NULL,
      84.511996,
      2.043549,
      9.277073,
      14.209547,
      34.394168,
      19.644645,
      35,
      16.362240,
      NULL,
      11.902995,
      28.060273,
      11,
      65,
      NULL,
      59,
      NULL,
      37,
      5,
      0.966547,
      38,
      125.979635,
      NULL,
      NULL,
      45,
      111.981720,
      '10-22-1976',
      NULL,
      NULL,
      26.521456,
      15.544513,
      190.077757,
      130.031555,
      ' 4-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      15,
      3.875485,
      15,
      4.968039,
      ' 2-27-1990',
      0.980105,
      0.023639,
      5.861772,
      NULL,
      0.183781,
      31.618043,
      NULL,
      0.225742,
      56.174226,
      NULL,
      NULL,
      NULL,
      ' 8-21-1997',
      8.388118,
      36.227500,
      37.148262,
      23.671727,
      38,
      37,
      NULL,
      58.641340,
      24,
      43.132844,
      1,
      63.035651,
      ' 9- 3-1987',
      14.344427,
      NULL,
      3.411126,
      6.492119,
      51,
      18.324527,
      3,
      ' 7-21-1990',
      5.015550,
      20.584942,
      ' 6-15-1993',
      5.515436,
      12.630485,
      14.821767,
      NULL,
      28,
      3,
      0,
      7,
      1.525666,
      NULL,
      1.360668,
      0,
      0,
      28.822023,
      1.350631,
      0.131790,
      0.824324,
      1,
      ' 0-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312822,
      ' 1-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1989',
      5,
      ' 3-11-1987',
      12.774280,
      NULL,
      ' 4- 8-1978',
      46,
      55,
      ' 8-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      11.195666,
      '10-27-1988',
      10.439832,
      43.623925,
      31.487512,
      '10-20-2002',
      1,
      109,
      ' 5- 1-2003',
      4,
      14.489873,
      14,
      49.764394,
      ' 9-26-1985',
      55.944604,
      NULL,
      NULL,
      ' 7-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


