set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8030435';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41322212',
      '32130121',
      NULL,
      NULL,
      '41234343',
      '23342222',
      '42424230',
      '00224332',
      '44224030',
      '32411420',
      '31214224',
      '20133110',
      '32003143',
      '30202102',
      '11130214',
      NULL,
      NULL,
      '04421122',
      '14141342',
      '01021412',
      '10430324',
      '00003241',
      '30040002',
      '22103211',
      '22341001',
      '20331323',
      '40430222',
      '32132223',
      '04341333',
      '20200231',
      '20204301',
      NULL,
      '11220114',
      '10310000',
      '04204212',
      '12221103',
      '31024421',
      '13342300',
      NULL,
      '24203202',
      '03400300',
      '10000203',
      '04221242',
      '31233131',
      NULL,
      '',
      NULL,
      NULL,
      '2310003',
      NULL,
      0.053134,
      2,
      NULL,
      '413012',
      0,
      ' 8-29-1986',
      ' 8-20-1979',
      59,
      NULL,
      NULL,
      23,
      NULL,
      24.499142,
      95,
      17,
      16.577576,
      7.439155,
      41,
      12.617004,
      46,
      1,
      2.633252,
      NULL,
      NULL,
      NULL,
      16,
      6.306412,
      56,
      NULL,
      41,
      12,
      NULL,
      63.631949,
      17.348426,
      69,
      158,
      29.018958,
      104.500565,
      ' 2-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.377293,
      7,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.573875,
      0.482616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-21-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.266907,
      84,
      45.893303,
      46.108109,
      68.539820,
      74,
      14.280772,
      88.667928,
      70,
      NULL,
      12.461325,
      4,
      '10-16-1975',
      35.946343,
      NULL,
      2.782859,
      NULL,
      NULL,
      119.070925,
      3.258510,
      '10-27-1978',
      9.589482,
      1.113834,
      ' 1-26-2001',
      NULL,
      2.563786,
      6,
      9,
      NULL,
      1,
      NULL,
      4.351566,
      NULL,
      75,
      1,
      3.380251,
      10.100106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      15.732419,
      6,
      ' 5-21-1986',
      1.319757,
      165,
      '11-13-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.156081,
      9,
      88.086224,
      NULL,
      8,
      10.052260,
      NULL,
      2.502823,
      6,
      4.969957,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123607,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      1.937408,
      NULL,
      1.834156,
      NULL,
      NULL,
      NULL,
      NULL,
      72,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.518502,
      NULL,
      1,
      1,
      2,
      53.890958,
      ' 7- 1-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-1982',
      NULL);
commit;
end;
/


