set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '1',
      '1',
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      '3',
      '3',
      '2',
      NULL,
      '2',
      '1',
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      '3',
      NULL,
      '4',
      '1',
      '1',
      '',
      '',
      '1',
      '1',
      '4',
      '0',
      '0',
      '1',
      '3',
      '3',
      '2',
      '4',
      '2',
      '240',
      '24113333',
      NULL,
      52.169331,
      '0010211',
      1.317129,
      1,
      NULL,
      NULL,
      NULL,
      3,
      ' 3-26-1993',
      ' 7-17-2003',
      38,
      168.810144,
      4,
      12,
      NULL,
      11.513789,
      62.663616,
      7,
      16.545506,
      12,
      29.587251,
      NULL,
      17.720078,
      11,
      2.036466,
      11,
      20.841784,
      3,
      NULL,
      9.569569,
      NULL,
      13,
      55.512697,
      NULL,
      NULL,
      6.774975,
      37.779127,
      73.961338,
      15,
      158.140970,
      21.965761,
      ' 5- 9-2001',
      NULL,
      57,
      15.693730,
      4,
      23.313842,
      NULL,
      ' 5-22-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993031,
      19.944027,
      10.939050,
      NULL,
      14.108004,
      4,
      NULL,
      0,
      0,
      130.207679,
      NULL,
      1,
      27.495985,
      0,
      1,
      23.724308,
      NULL,
      NULL,
      NULL,
      ' 5-17-1996',
      15,
      92.392786,
      57,
      21.047517,
      24,
      60,
      28.717349,
      84,
      20,
      62.638192,
      NULL,
      31,
      ' 4-15-1985',
      5,
      2.056214,
      6,
      7.534393,
      28,
      0,
      1,
      ' 1-19-1991',
      22.436385,
      6.915092,
      '11- 6-1994',
      7.747853,
      NULL,
      13,
      15.788131,
      8,
      6,
      1.370979,
      NULL,
      0.935926,
      19,
      1,
      NULL,
      1,
      NULL,
      4,
      5,
      1,
      1.000933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.185551,
      ' 9-28-1983',
      NULL,
      NULL,
      NULL,
      25.590998,
      NULL,
      32,
      ' 2- 7-1992',
      7.088743,
      12.835105,
      ' 1-13-1991',
      50.717946,
      47.330853,
      ' 8- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      ' 1-17-1995',
      42,
      13,
      9.928113,
      ' 2- 1-1982',
      2,
      75.381709,
      NULL,
      NULL,
      18,
      NULL,
      36.227815,
      ' 4-23-1985',
      42,
      0.968840,
      154.088592,
      ' 6- 7-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


