set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      '2',
      '4',
      '1',
      '2',
      '2',
      '4',
      '0',
      '4',
      '3',
      '2',
      '',
      '4',
      NULL,
      '3',
      '0',
      '0',
      '4',
      '3',
      '',
      '',
      '3',
      '2',
      '4',
      NULL,
      '2',
      '1',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      '002',
      NULL,
      NULL,
      41.099063,
      '1234343',
      2,
      2,
      2,
      NULL,
      '223033',
      4.383160,
      ' 3- 6-1982',
      ' 7-15-2001',
      56,
      44,
      19,
      11,
      6.319957,
      5,
      47,
      5,
      19.943857,
      1.133530,
      28,
      11.638844,
      2,
      13,
      22,
      NULL,
      0.146159,
      4,
      13.038177,
      0.387318,
      34,
      NULL,
      81,
      NULL,
      0,
      80.205574,
      137,
      28,
      NULL,
      NULL,
      NULL,
      ' 5-20-2002',
      28,
      41,
      NULL,
      30,
      40,
      47,
      ' 5- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      58.761153,
      27,
      48.077005,
      3.368134,
      0,
      ' 8-29-1989',
      0,
      1.610433,
      138.153495,
      1,
      0.026083,
      62.776913,
      1.854711,
      0.770609,
      62,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1995',
      93,
      100,
      99.097757,
      6.665820,
      84,
      41,
      66.313440,
      81.252348,
      66,
      NULL,
      89.455670,
      NULL,
      '11-23-1985',
      11.588911,
      NULL,
      9,
      39,
      24.356213,
      34.322985,
      NULL,
      ' 6- 5-1980',
      10,
      0.551010,
      ' 1-25-1976',
      6,
      5.871923,
      7.394819,
      NULL,
      NULL,
      1,
      1.319547,
      2.902061,
      0,
      13.091516,
      1,
      NULL,
      NULL,
      7,
      0.353357,
      6.433411,
      1,
      0,
      ' 5-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      106.213242,
      NULL,
      ' 5- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      ' 5-12-2000',
      5.772169,
      4.697197,
      ' 7-27-1983',
      63.557985,
      87,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      19.744169,
      ' 2-21-2001',
      72,
      1,
      9,
      ' 7- 8-2000',
      1.294033,
      NULL,
      NULL,
      NULL,
      25,
      19.992624,
      57,
      ' 7-22-1975',
      22,
      0.033112,
      62.667748,
      ' 1- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


