set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '0',
      '0',
      '2',
      '4',
      '4',
      '4',
      '4',
      '0',
      '3',
      '3',
      NULL,
      '1',
      '3',
      '2',
      NULL,
      '3',
      '4',
      '4',
      '0',
      '2',
      '4',
      '4',
      NULL,
      '0',
      '',
      '3',
      '1',
      NULL,
      '0',
      '4',
      '',
      '',
      '4',
      NULL,
      '3',
      '0',
      '1',
      '4',
      '0',
      '1',
      NULL,
      '0',
      '3',
      '140',
      '00200424',
      6.694713,
      30,
      '2340041',
      3,
      93.727049,
      2,
      NULL,
      '130120',
      NULL,
      '10-23-2001',
      '11- 9-1983',
      37,
      NULL,
      16,
      2,
      2,
      0.212697,
      NULL,
      NULL,
      2,
      1.874258,
      4,
      2,
      NULL,
      17.161145,
      21.762773,
      10,
      11.496944,
      3.740661,
      30.085125,
      17.592476,
      46.166746,
      12,
      15.368118,
      17,
      1.143544,
      66,
      4,
      42.549563,
      130.689220,
      NULL,
      26,
      ' 0-17-1998',
      49,
      16,
      9.218168,
      17,
      6,
      188.917429,
      ' 0-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      12,
      NULL,
      NULL,
      0.526975,
      2,
      ' 5-22-1975',
      1.277485,
      0.550709,
      202.885072,
      0.938099,
      1.911407,
      198.351758,
      1.348254,
      0,
      6,
      NULL,
      NULL,
      NULL,
      ' 3-29-1979',
      117,
      35.594346,
      NULL,
      NULL,
      79.497530,
      111.920776,
      72,
      88.372558,
      83.389321,
      3.936692,
      NULL,
      88.436299,
      ' 5-25-1988',
      16.569477,
      2.367741,
      6.881959,
      37.399950,
      41,
      4.644845,
      1.878192,
      ' 6-15-1974',
      1,
      15,
      ' 4-22-2001',
      11.827221,
      0,
      8.275692,
      7,
      13,
      NULL,
      0.180639,
      3,
      0,
      32,
      NULL,
      NULL,
      NULL,
      0,
      8.292971,
      1,
      0,
      0.525382,
      ' 2- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      194.310090,
      3,
      ' 3-16-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-1998',
      20,
      '11-21-2003',
      NULL,
      15.490438,
      ' 4-22-1984',
      NULL,
      45,
      ' 4-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 6-29-1975',
      NULL,
      33.068541,
      NULL,
      ' 0-20-1991',
      1,
      107.342983,
      NULL,
      8,
      30,
      NULL,
      5,
      '10-13-1978',
      73,
      0,
      96.077933,
      ' 5-11-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


