set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9411501';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '00240020',
      '00003431',
      '34412324',
      '33140142',
      '14203210',
      '14320443',
      '41423311',
      '33024004',
      NULL,
      '13434401',
      NULL,
      NULL,
      '24003000',
      '22120202',
      '01401344',
      NULL,
      '34221423',
      '30431110',
      '33312400',
      '30220204',
      '01134001',
      NULL,
      '40010000',
      '44244422',
      NULL,
      '01321104',
      '31443010',
      '03221212',
      '30043120',
      '24020440',
      '02340114',
      NULL,
      '24042040',
      '42424312',
      '03221140',
      NULL,
      '43244423',
      '00112124',
      '04314012',
      NULL,
      NULL,
      '24200213',
      '42242333',
      '202',
      '00',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      '112023',
      NULL,
      ' 8- 8-1998',
      ' 2-16-2003',
      21.139665,
      NULL,
      12,
      6,
      0,
      7,
      7,
      16,
      2,
      18,
      NULL,
      15.617898,
      12.414711,
      14.418958,
      6,
      1,
      NULL,
      3.712930,
      11.101473,
      9,
      45.737647,
      0.545623,
      13,
      11.687042,
      NULL,
      74.511063,
      43,
      NULL,
      89,
      120,
      104,
      ' 4-28-1986',
      1,
      23,
      27.268949,
      1.463620,
      180,
      116,
      ' 7-25-1983',
      4.911908,
      3,
      2,
      5.260884,
      1.394726,
      3,
      1.053109,
      3.292654,
      0,
      0.966827,
      1.769270,
      1,
      NULL,
      4.106869,
      0,
      1,
      5.948234,
      NULL,
      1,
      2.723009,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 1-1995',
      71.007709,
      NULL,
      0,
      NULL,
      7,
      2.353200,
      '11-26-1976',
      NULL,
      2.276295,
      154.149381,
      0,
      NULL,
      5,
      1.464571,
      5.995919,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1975',
      NULL,
      NULL,
      91.822725,
      51,
      20.298707,
      43,
      55,
      52,
      31,
      40,
      39.013692,
      24.851675,
      ' 3-12-1990',
      11,
      4,
      14,
      32,
      28.748288,
      22,
      0,
      '11-11-1982',
      20,
      5.964211,
      ' 1-20-1998',
      NULL,
      0.193173,
      28,
      25.342290,
      16,
      11.691377,
      1,
      24.269461,
      0,
      101,
      1.419499,
      1.436428,
      10,
      23.275444,
      NULL,
      0.115182,
      3.797520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      191.648986,
      3.783737,
      ' 2-29-1977',
      NULL,
      NULL,
      NULL,
      16,
      ' 3-11-1976',
      37.283064,
      ' 1-12-1988',
      10,
      14,
      NULL,
      78,
      91.651788,
      ' 1- 0-1986',
      0.962672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      27.877315,
      ' 4-14-2000',
      NULL,
      13.349882,
      7,
      '11-19-2002',
      NULL,
      90.104911,
      ' 6- 9-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


