set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726236';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0141',
      '21411311',
      '02413324',
      NULL,
      '04242401',
      '33214201',
      NULL,
      '41334224',
      NULL,
      NULL,
      '13112014',
      '33021321',
      '40423030',
      '24044424',
      '03123044',
      '23141114',
      '12240212',
      '23203423',
      '23203020',
      NULL,
      '42122034',
      '30141201',
      '20404000',
      '33110410',
      '43121133',
      '32202214',
      '41414210',
      '12302121',
      '32112303',
      NULL,
      '42321242',
      '31320140',
      '02333421',
      '30111041',
      '32222202',
      '04014324',
      '33314233',
      NULL,
      '04344142',
      NULL,
      '22133302',
      '10233144',
      '12011423',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1124424',
      1.081488,
      NULL,
      2,
      NULL,
      '330344',
      NULL,
      ' 1-27-1999',
      ' 3-22-2000',
      120,
      NULL,
      14,
      NULL,
      9,
      NULL,
      36,
      NULL,
      15,
      5,
      0.996643,
      8,
      NULL,
      NULL,
      1.036348,
      6.108815,
      8.948865,
      2.763187,
      NULL,
      NULL,
      28,
      7,
      24,
      NULL,
      1,
      14,
      63,
      54.095508,
      58.441298,
      NULL,
      85,
      ' 4-21-1990',
      NULL,
      25.039186,
      NULL,
      10,
      NULL,
      NULL,
      ' 7-24-1986',
      NULL,
      2.770766,
      1.534081,
      1.330667,
      0,
      2,
      NULL,
      4,
      0.198368,
      1,
      1,
      1,
      0,
      5,
      1,
      0.116706,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1990',
      14.934377,
      12.429438,
      4,
      5.740725,
      13.905149,
      NULL,
      ' 6- 9-1990',
      NULL,
      2,
      NULL,
      0,
      1,
      122,
      NULL,
      0.452630,
      22.404125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      28.659853,
      31,
      45,
      77.954252,
      72,
      34.896408,
      29,
      60,
      NULL,
      25,
      ' 1- 6-1994',
      17,
      NULL,
      5.861525,
      38.382426,
      NULL,
      25,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      ' 4- 7-1974',
      11.625737,
      ' 4-19-1996',
      6.194075,
      9.526173,
      NULL,
      NULL,
      NULL,
      NULL,
      2.243392,
      8,
      ' 3- 2-2003',
      NULL,
      NULL,
      NULL,
      3,
      1,
      15.404305,
      ' 2-21-2001',
      56,
      5.440618,
      11,
      ' 8- 0-1983',
      0.043189,
      132.257941,
      ' 6- 7-1980',
      8.178013,
      19,
      3.102949,
      0,
      NULL,
      22,
      0.743781,
      219,
      ' 3- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


