set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9657548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43130022',
      '20030324',
      '10141331',
      '00224423',
      '41430022',
      '40013440',
      '01140343',
      '20232400',
      '34411202',
      '04441204',
      '31003331',
      NULL,
      '01202131',
      NULL,
      '41211204',
      '02230014',
      '40422034',
      NULL,
      NULL,
      NULL,
      NULL,
      '11410030',
      '33001032',
      '22003113',
      '31312423',
      '40102242',
      NULL,
      '11044233',
      '04431202',
      NULL,
      '12002312',
      '42344401',
      '42002010',
      '14342341',
      '21311204',
      '44311044',
      '12443133',
      NULL,
      '21310134',
      '03212003',
      '03120311',
      '44122413',
      NULL,
      '30040040',
      '344',
      NULL,
      23.135709,
      9,
      NULL,
      1.318564,
      NULL,
      0,
      NULL,
      '104444',
      3,
      ' 1-18-1995',
      '11-19-1995',
      54.988306,
      16.596612,
      1.860732,
      NULL,
      9,
      15,
      60,
      6,
      NULL,
      18,
      NULL,
      5.043558,
      NULL,
      NULL,
      18,
      0,
      8,
      9.489216,
      20.636349,
      7.605030,
      11,
      17,
      0.207624,
      7.938625,
      1.986398,
      70,
      NULL,
      49,
      87,
      77.401643,
      31.689875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.867824,
      59,
      0,
      14,
      9,
      0,
      ' 9- 2-1981',
      0.247496,
      NULL,
      52.785422,
      1.195144,
      NULL,
      40.614783,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 4-1977',
      NULL,
      108,
      31.404527,
      39,
      4.908351,
      104,
      NULL,
      73,
      97.956408,
      NULL,
      68,
      9,
      ' 4-13-1999',
      16.254320,
      19.700500,
      6.266018,
      26.739260,
      NULL,
      42,
      3,
      ' 1- 9-1981',
      0.279093,
      NULL,
      ' 8- 2-1996',
      1.390163,
      7.499853,
      6.625208,
      14,
      8.592290,
      1.872276,
      0.032503,
      1.093785,
      0.322207,
      53.056772,
      5.877740,
      3.651551,
      0.818694,
      18.112795,
      2,
      4.444714,
      NULL,
      1.582085,
      ' 3-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      '10-15-1978',
      2,
      ' 2-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.070431,
      '11- 3-1987',
      27.000717,
      NULL,
      NULL,
      ' 9-23-1990',
      5.052957,
      1.048698,
      ' 5-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


