set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '3',
      '2',
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      '3',
      NULL,
      '4',
      '3',
      '1',
      '3',
      '3',
      '1',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      '',
      '1',
      '',
      NULL,
      '4',
      '2',
      NULL,
      '1',
      '',
      '',
      '4',
      '0',
      '1',
      '3',
      '3',
      '2',
      '0',
      '2',
      '0',
      '4',
      '4',
      '240',
      NULL,
      50.955570,
      31,
      '0040133',
      3.037401,
      0,
      NULL,
      NULL,
      '034234',
      3,
      ' 0- 0-1995',
      NULL,
      74.341973,
      126,
      6,
      NULL,
      20,
      12,
      20.336633,
      14.438318,
      6.241333,
      3.141618,
      16.984424,
      0.426921,
      25.908846,
      6,
      13.216799,
      11.663771,
      2.641869,
      0.581521,
      15,
      10.217137,
      3.380911,
      3.173310,
      6.813638,
      9.776141,
      1.461547,
      NULL,
      161,
      14,
      56,
      2.031846,
      31,
      ' 3-20-1995',
      26,
      4,
      24.204171,
      4.354508,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.591947,
      27.881052,
      14.981918,
      3,
      13.295656,
      NULL,
      ' 3- 0-1974',
      0.982875,
      0,
      NULL,
      NULL,
      NULL,
      95.856490,
      0,
      1.001879,
      69,
      NULL,
      NULL,
      NULL,
      '11-16-1991',
      NULL,
      79,
      67,
      52,
      NULL,
      2.482196,
      56,
      34.990495,
      50,
      46,
      59.368577,
      49.572359,
      ' 4-12-1985',
      3,
      1.628232,
      NULL,
      0,
      30.870542,
      5.851073,
      0.139365,
      ' 7-27-2000',
      19.236670,
      14,
      ' 2- 0-2001',
      NULL,
      2,
      14.000627,
      10,
      3,
      0.455654,
      1.826518,
      5,
      NULL,
      NULL,
      1.839308,
      1,
      3.802360,
      5,
      1.075015,
      NULL,
      0,
      0.245282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.983022,
      81.090639,
      '10-26-1974',
      NULL,
      NULL,
      NULL,
      13.973333,
      ' 7-26-1996',
      0.544967,
      ' 1-14-1988',
      11.461240,
      0.830997,
      ' 6-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      '11-28-1984',
      22.111738,
      18,
      21.905576,
      ' 0- 2-2001',
      0,
      NULL,
      ' 1-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


