set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '1',
      '0',
      '0',
      '2',
      '0',
      '2',
      '2',
      NULL,
      NULL,
      '4',
      '3',
      '4',
      '3',
      '1',
      NULL,
      NULL,
      '1',
      '4',
      '3',
      '4',
      '1',
      '4',
      NULL,
      '4',
      '',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '',
      '',
      '2',
      '3',
      NULL,
      '0',
      '3',
      '4',
      NULL,
      '0',
      NULL,
      '3',
      '0',
      '344',
      '42311022',
      62.062743,
      40.234413,
      '2330240',
      0,
      1,
      0,
      0,
      NULL,
      4,
      ' 4- 9-1995',
      ' 7- 2-1998',
      62.589072,
      NULL,
      6,
      15,
      0,
      11,
      NULL,
      6,
      4.887912,
      16.845722,
      0,
      10.681589,
      10.600452,
      11.226107,
      11,
      7.522586,
      0.467000,
      6,
      5,
      5,
      NULL,
      1,
      59,
      4,
      0,
      NULL,
      51.083857,
      NULL,
      125,
      39,
      157.124176,
      ' 2- 1-1990',
      31.098276,
      10,
      10.804814,
      NULL,
      58.499833,
      152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579199,
      1.859809,
      156,
      NULL,
      0.323819,
      82.018436,
      1,
      1.227810,
      5,
      NULL,
      NULL,
      NULL,
      ' 4-25-1985',
      35.667049,
      93.592925,
      58.138131,
      80.571579,
      42.119946,
      4.368378,
      83.433215,
      57.396143,
      NULL,
      44.335835,
      3,
      9,
      '10-18-1985',
      13.269838,
      9,
      1,
      NULL,
      30.391773,
      4,
      0,
      ' 7- 5-1983',
      5,
      NULL,
      NULL,
      3,
      6,
      NULL,
      NULL,
      7.482913,
      5.437540,
      NULL,
      NULL,
      1,
      39.126645,
      3,
      1,
      5.986733,
      13,
      NULL,
      0.684003,
      1,
      1,
      ' 0-12-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      24.548475,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-25-1994',
      7.226120,
      ' 4-20-2003',
      NULL,
      0.118662,
      ' 1- 9-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      ' 6-11-1977',
      20.504321,
      6,
      3.714672,
      NULL,
      0,
      64,
      ' 9-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


