set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0330',
      NULL,
      '42033013',
      '10022111',
      '13244401',
      '44430313',
      '11403341',
      '41414440',
      NULL,
      '13401310',
      NULL,
      '10324340',
      '33214243',
      '41343331',
      '23312010',
      NULL,
      '00004203',
      '41414034',
      '33242221',
      '23330112',
      '42344042',
      NULL,
      '21210241',
      '40030322',
      '04241432',
      '32130103',
      NULL,
      '13310333',
      NULL,
      '44202243',
      '40032211',
      '13100120',
      '22324144',
      '23030301',
      '44131043',
      '10120130',
      NULL,
      '02300223',
      '44340011',
      '01302013',
      '43243410',
      '20103334',
      NULL,
      '21210213',
      '00144000',
      '',
      '',
      NULL,
      NULL,
      '0003432',
      3,
      NULL,
      0,
      NULL,
      NULL,
      3.936476,
      '11-26-1981',
      '10- 8-1993',
      4.892122,
      NULL,
      14.363277,
      NULL,
      15,
      NULL,
      31.272332,
      NULL,
      NULL,
      6,
      29,
      10,
      NULL,
      NULL,
      2,
      11.409113,
      31.336162,
      11,
      56.401631,
      3.150109,
      50,
      9.078498,
      NULL,
      4.717220,
      NULL,
      105.375720,
      47.316291,
      NULL,
      53.440952,
      NULL,
      202,
      NULL,
      3.792999,
      16,
      6,
      17.413546,
      NULL,
      40,
      NULL,
      11,
      3,
      2.934199,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.605855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-2000',
      NULL,
      96.024389,
      38.240338,
      1.631925,
      NULL,
      99,
      6.422182,
      31.486609,
      60.212957,
      47,
      NULL,
      3,
      ' 6-17-1987',
      1.085404,
      21,
      16,
      57,
      7,
      62,
      NULL,
      '10-17-1976',
      NULL,
      21,
      ' 1-18-1999',
      8.495459,
      10,
      10.575701,
      4,
      13.074702,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      0.298773,
      1.676751,
      12.037651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      57.939753,
      10,
      ' 5-17-1988',
      NULL,
      66,
      ' 0-27-1995',
      19,
      28,
      15,
      15,
      ' 5-28-1975',
      40,
      NULL,
      143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      12.191221,
      NULL,
      4.292991,
      23.250232,
      NULL,
      13.199555,
      NULL,
      1,
      0,
      29.648440,
      0,
      0.966899,
      85,
      0,
      2.719292,
      60,
      NULL,
      2,
      47,
      NULL,
      22,
      NULL,
      0.353928,
      NULL,
      1,
      1,
      0.249385,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      12.973903,
      NULL,
      NULL,
      NULL,
      NULL,
      2.624004,
      1,
      1,
      0.599393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10.667203,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      4.794911,
      5,
      1.482194,
      NULL,
      NULL,
      2,
      NULL,
      1.972564,
      NULL,
      NULL,
      ' 9-17-1976',
      NULL,
      ' 3-20-1977',
      '10-14-1976',
      '11- 7-1988',
      ' 2- 5-1982',
      NULL);
commit;
end;
/


