set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030238';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2010',
      '43233120',
      '13001324',
      '10423300',
      NULL,
      '33244302',
      '11343111',
      '41143043',
      '40101312',
      NULL,
      '43023133',
      NULL,
      NULL,
      NULL,
      '10044001',
      '41402301',
      '31234323',
      '31111242',
      NULL,
      '23420204',
      '14332302',
      NULL,
      '31203210',
      '32131331',
      '01231142',
      '34030101',
      '32220040',
      '30030002',
      '22203222',
      '10221323',
      NULL,
      NULL,
      '14143401',
      '32433343',
      '31314412',
      NULL,
      '40342401',
      '23212110',
      '04241134',
      '14444031',
      '03400010',
      '44240224',
      '13012433',
      '03123443',
      '00022221',
      '',
      '',
      NULL,
      NULL,
      '4221421',
      3,
      0,
      1,
      NULL,
      '410343',
      2,
      '11- 1-1984',
      ' 0- 6-1994',
      NULL,
      NULL,
      6,
      7.971718,
      NULL,
      5.070140,
      40,
      2.192080,
      1,
      NULL,
      21.194328,
      11.520466,
      4.627669,
      14.975476,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      13.296563,
      0.354158,
      NULL,
      3,
      NULL,
      38,
      89,
      27,
      155,
      114.184483,
      20.945109,
      ' 7- 2-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.008322,
      4.691924,
      1.511697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.602846,
      NULL,
      0.949324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-1978',
      73.677913,
      106,
      15,
      90.877156,
      18.301287,
      88.817951,
      79.101897,
      56.903479,
      25.640069,
      NULL,
      43.092973,
      86.530346,
      ' 3-14-1996',
      9.601090,
      3,
      0,
      13,
      26,
      0.083705,
      4,
      ' 3-12-1984',
      26,
      14.124604,
      NULL,
      0,
      NULL,
      12.710366,
      NULL,
      15,
      5,
      NULL,
      5,
      NULL,
      45.351186,
      NULL,
      8,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      10,
      ' 1-19-1976',
      0.889990,
      NULL,
      ' 6-21-2003',
      6,
      38.978966,
      18,
      9,
      ' 7-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.969472,
      58.930165,
      18,
      NULL,
      54,
      88.565501,
      100.767839,
      28.644847,
      31,
      2.471978,
      31.285766,
      0,
      0,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542523,
      173,
      8,
      13,
      166,
      NULL,
      13,
      40,
      1.456140,
      31.068721,
      NULL,
      1,
      NULL,
      2,
      0.993062,
      NULL,
      51.014768,
      16.613559,
      NULL,
      NULL,
      NULL,
      0,
      1.472879,
      71.519037,
      46,
      0.963571,
      5.021339,
      3.764608,
      4,
      NULL,
      31,
      1.338606,
      46,
      0,
      0.693258,
      NULL,
      17,
      NULL,
      18,
      45,
      NULL,
      NULL,
      17,
      4.750659,
      1.432331,
      0.503389,
      1,
      1,
      1,
      0.518642,
      1,
      NULL,
      ' 1-24-1995',
      '11-19-1974',
      ' 6- 4-1999',
      ' 4- 3-1996',
      '11- 8-2002',
      ' 0-16-2000',
      ' 4-27-1975',
      NULL);
commit;
end;
/


