set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9776229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '1',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      '1',
      '0',
      '2',
      '3',
      '2',
      '3',
      '1',
      '0',
      NULL,
      '4',
      '1',
      '2',
      '0',
      NULL,
      '',
      '3',
      NULL,
      '4',
      '3',
      '2',
      NULL,
      '3',
      '',
      '',
      '4',
      NULL,
      '0',
      '2',
      '4',
      '3',
      '2',
      '3',
      '4',
      '2',
      NULL,
      NULL,
      '02203131',
      NULL,
      NULL,
      NULL,
      2.885899,
      1.448012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-10-1975',
      4,
      NULL,
      28,
      7,
      29.130562,
      4,
      41.746927,
      21.627486,
      15.997184,
      9,
      44,
      15,
      0.973552,
      13,
      4,
      30,
      NULL,
      16.640212,
      66.530953,
      13.742910,
      33,
      24.357949,
      14.055381,
      NULL,
      1,
      106.863494,
      147.360556,
      93.475487,
      NULL,
      127.272854,
      172,
      ' 5- 4-2001',
      26,
      49.955793,
      26.115861,
      5,
      NULL,
      22,
      ' 2- 3-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.100188,
      NULL,
      1,
      14.211395,
      9.784062,
      NULL,
      ' 5-19-1989',
      1,
      NULL,
      166.599747,
      0,
      1.847135,
      82.998216,
      1,
      0.055823,
      67,
      NULL,
      NULL,
      NULL,
      '10-27-1974',
      40,
      12,
      29.903669,
      67,
      8,
      11,
      15.727551,
      NULL,
      77,
      84.335223,
      NULL,
      37,
      ' 9- 2-1990',
      17,
      12.073711,
      9.657747,
      24.995662,
      83,
      NULL,
      6.308891,
      ' 4- 3-1979',
      23.161133,
      NULL,
      '10-13-1976',
      9.972257,
      14,
      16,
      18.473775,
      23,
      10,
      1,
      18.891079,
      1.768512,
      134.570977,
      1,
      NULL,
      NULL,
      29.815698,
      0,
      0,
      1,
      NULL,
      ' 8-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      11,
      ' 8-18-2001',
      NULL,
      NULL,
      NULL,
      0,
      '11- 7-2001',
      45,
      ' 9-28-1990',
      0.443593,
      10,
      ' 4-29-1999',
      92.591790,
      NULL,
      ' 9- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      14.455610,
      ' 1- 1-1982',
      40,
      27.883700,
      16.006995,
      ' 8- 9-1985',
      NULL,
      21,
      '10-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


