set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829762';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3312',
      '22430120',
      NULL,
      NULL,
      '02103433',
      '12344432',
      NULL,
      '00122412',
      '20021110',
      '20400232',
      '42131240',
      '31000120',
      '44324341',
      NULL,
      '23030144',
      '20433444',
      '03143413',
      '02231102',
      '00331210',
      '34113442',
      '21121443',
      '23320141',
      NULL,
      '10110320',
      '02011424',
      '02304241',
      '33314232',
      NULL,
      '41410441',
      '10320243',
      '32440303',
      '03242414',
      '33322412',
      '20121234',
      '14002210',
      '01041140',
      NULL,
      NULL,
      NULL,
      '10233013',
      '30442441',
      '10204030',
      '42014133',
      '40341122',
      '10043343',
      NULL,
      '',
      NULL,
      NULL,
      '0424124',
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      ' 7-18-1997',
      NULL,
      53,
      NULL,
      35,
      14.044336,
      NULL,
      17,
      96,
      10,
      17.032123,
      3,
      10.946920,
      20.426740,
      32,
      NULL,
      18,
      NULL,
      27.713095,
      15.695500,
      NULL,
      20,
      35.079037,
      10,
      44,
      NULL,
      NULL,
      46.193630,
      45.437123,
      11,
      166.084448,
      203.980140,
      35,
      NULL,
      NULL,
      7.641686,
      6,
      18,
      58.125050,
      NULL,
      ' 4-25-1995',
      2,
      2,
      NULL,
      1.704998,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849016,
      0.474504,
      NULL,
      0.794075,
      1.223805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1995',
      61.191715,
      83.641180,
      69.498293,
      100,
      41.983439,
      NULL,
      39,
      NULL,
      39,
      44.907328,
      40,
      69.909811,
      NULL,
      NULL,
      6,
      7.269308,
      68,
      55.184302,
      72,
      1.747488,
      '11-15-1976',
      9.398130,
      30.739645,
      ' 7-19-2001',
      2,
      12.343821,
      NULL,
      28,
      20,
      8,
      NULL,
      9.114186,
      NULL,
      121,
      0.618170,
      4.794445,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-13-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      38.077401,
      14.520853,
      ' 5- 6-1977',
      1,
      NULL,
      '10-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-13-1996',
      70.854129,
      0.658272,
      101,
      ' 4-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      21,
      3.747901,
      7.329824,
      3.219149,
      4,
      NULL,
      1,
      NULL,
      78,
      0,
      0.881744,
      23,
      0.854963,
      0,
      NULL,
      0,
      1,
      52.908239,
      NULL,
      1.500685,
      NULL,
      1,
      NULL,
      NULL,
      0.989181,
      1.423903,
      0,
      1.669723,
      1.848328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      6,
      0.345541,
      21.525820,
      0,
      NULL,
      0,
      NULL,
      0.432206,
      NULL,
      NULL,
      20.850090,
      12,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      8.486866,
      NULL,
      1.916004,
      3,
      0.484315,
      NULL,
      0,
      3.038341,
      NULL,
      ' 6- 9-1986',
      ' 6-25-1982',
      ' 2-11-1997',
      '11- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


