set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0100',
      '44121123',
      '33412430',
      '13403310',
      '31234422',
      '14231003',
      '22314343',
      '32301433',
      NULL,
      '21200314',
      '03144023',
      '43332402',
      '14130033',
      '00120421',
      '40214221',
      NULL,
      '44412300',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03033203',
      NULL,
      '32314331',
      '33111103',
      NULL,
      '00100130',
      '22103414',
      '03331214',
      '22420321',
      '32222142',
      NULL,
      NULL,
      NULL,
      NULL,
      '11240313',
      NULL,
      '24242011',
      '10431344',
      '32101020',
      '43423301',
      '41131303',
      '24244400',
      '20104130',
      '213',
      '44',
      NULL,
      NULL,
      NULL,
      NULL,
      0.040756,
      2,
      NULL,
      '411310',
      3.662374,
      ' 9-25-1994',
      ' 1-25-2002',
      13,
      NULL,
      8,
      24.273158,
      5,
      1.476190,
      19.997409,
      7.859926,
      NULL,
      7.503864,
      43.094358,
      3.706002,
      29,
      NULL,
      22,
      NULL,
      3,
      27,
      NULL,
      4.621465,
      61,
      10.505620,
      42.656724,
      12.460779,
      1.690953,
      95,
      127.981436,
      NULL,
      64.347162,
      NULL,
      27,
      NULL,
      40,
      NULL,
      33.022720,
      7,
      58,
      199,
      ' 7- 9-1993',
      3.336206,
      NULL,
      NULL,
      5.131701,
      4.467030,
      NULL,
      7.193261,
      2,
      NULL,
      NULL,
      1.738996,
      NULL,
      1.980277,
      1.991789,
      1,
      1,
      NULL,
      NULL,
      1.707268,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100489,
      1.927335,
      75,
      NULL,
      0,
      150.647009,
      1.508131,
      NULL,
      39.496538,
      NULL,
      1,
      38.170595,
      ' 4- 8-1979',
      48.614175,
      51.581536,
      78.171072,
      76.658220,
      43,
      44,
      70,
      51.962459,
      57.819316,
      68,
      42,
      NULL,
      NULL,
      16,
      NULL,
      3,
      NULL,
      17,
      69,
      NULL,
      ' 4-14-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.375773,
      NULL,
      NULL,
      NULL,
      15.074256,
      '10- 5-1997',
      NULL,
      2,
      '10-13-1989',
      18.815619,
      NULL,
      NULL,
      ' 3- 8-1981',
      NULL,
      17.463062,
      ' 3-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      4.443493,
      ' 8-28-1976',
      52,
      18.926506,
      6.806335,
      ' 1-13-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.001952);
commit;
end;
/


