set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3243',
      '43333301',
      '01003223',
      '30331044',
      '31213403',
      '04433103',
      '43330410',
      '42240242',
      '02102114',
      '40401414',
      '33302310',
      '10031121',
      '01121133',
      '22440301',
      '03131222',
      NULL,
      NULL,
      '03223410',
      '23314041',
      NULL,
      '30101022',
      '22121321',
      '41012110',
      '00444344',
      NULL,
      NULL,
      '44201411',
      '34230303',
      NULL,
      '32323113',
      NULL,
      '04333310',
      '04222032',
      '31132343',
      NULL,
      '42331413',
      NULL,
      '42422401',
      '23140132',
      '14321330',
      '32220402',
      '43324012',
      NULL,
      '40213000',
      '10001212',
      '',
      '',
      NULL,
      NULL,
      NULL,
      1.147636,
      1.337055,
      NULL,
      NULL,
      '340341',
      1,
      ' 0-17-1992',
      NULL,
      75.024165,
      NULL,
      8,
      16,
      27.121403,
      8.228978,
      14.990817,
      14.915569,
      NULL,
      26,
      45.204343,
      16.999200,
      10.505011,
      6.765263,
      1.344653,
      1,
      21,
      13,
      36,
      0,
      NULL,
      11,
      NULL,
      23,
      NULL,
      44.646238,
      76.798448,
      62.023697,
      161.835464,
      180.838728,
      126,
      ' 7- 2-1978',
      21,
      23,
      NULL,
      NULL,
      22.454213,
      76,
      '10- 7-1999',
      1,
      NULL,
      0.709274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.557788,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 4-1986',
      68.139754,
      91,
      64.512401,
      51,
      36.207969,
      NULL,
      21,
      NULL,
      43,
      8.475495,
      124.589191,
      93.830140,
      '10-15-1979',
      11.971547,
      25,
      21.992919,
      18.635698,
      40,
      103.721484,
      11,
      ' 5-11-1981',
      0,
      24.659370,
      ' 5-12-1994',
      NULL,
      11,
      5,
      21.539915,
      NULL,
      4.381833,
      NULL,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.829735,
      NULL,
      39.849325,
      ' 6-12-1995',
      0.760195,
      38.805664,
      ' 0-23-1993',
      18,
      28,
      0,
      27.496917,
      NULL,
      44.524180,
      1,
      NULL,
      ' 9-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1.056255,
      0,
      NULL,
      NULL,
      NULL,
      17.878068,
      16,
      2.712471,
      5.403344,
      NULL,
      NULL,
      1,
      1.916474,
      NULL,
      NULL,
      1.628319,
      NULL,
      1.716419,
      0,
      137.571070,
      NULL,
      8,
      58.219823,
      NULL,
      16.482685,
      NULL,
      1,
      NULL,
      1.343854,
      0.404768,
      1.119045,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531295,
      29,
      NULL,
      1,
      1,
      7,
      1.545236,
      NULL,
      0.164656,
      NULL,
      1.939037,
      1.146136,
      NULL,
      9,
      4.769429,
      23,
      NULL,
      NULL,
      1,
      NULL,
      17.458156,
      2,
      1,
      NULL,
      0.846292,
      1.317078,
      1.016677,
      3,
      NULL,
      ' 3- 0-1981',
      '10- 7-2001',
      '10- 6-1977',
      NULL,
      ' 3-24-1986',
      ' 3-13-1977',
      ' 3- 0-1989',
      NULL);
commit;
end;
/


