set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2300',
      NULL,
      '34024304',
      '32412443',
      '14012220',
      '31132002',
      '21402234',
      '31443133',
      '40132440',
      '03212241',
      NULL,
      '40342414',
      '30302334',
      '24404343',
      '43210114',
      '10034433',
      '14021413',
      '30143214',
      '21120340',
      NULL,
      '34233123',
      '14204024',
      '01023213',
      '44220213',
      '04000130',
      '01022010',
      '20240420',
      '11044431',
      '01433242',
      '43032321',
      '40200202',
      '22343441',
      NULL,
      '41130130',
      '00421131',
      '13122420',
      '41022314',
      '24322244',
      NULL,
      '01320210',
      '40244440',
      '12213011',
      '41421001',
      '11220330',
      NULL,
      '142',
      '10',
      NULL,
      NULL,
      '4022300',
      NULL,
      0,
      NULL,
      NULL,
      '420243',
      NULL,
      ' 1-18-1982',
      '10-10-1997',
      98,
      NULL,
      35,
      7.446291,
      8,
      8.983874,
      68.930049,
      NULL,
      22.629995,
      15.465648,
      15,
      0.731082,
      3,
      17.201642,
      NULL,
      4.518397,
      5,
      11.245723,
      25.865512,
      8,
      37.109891,
      14,
      21.365968,
      7.843345,
      1.300075,
      NULL,
      40,
      24.931071,
      140.858703,
      NULL,
      NULL,
      ' 7-28-1976',
      36.676007,
      35,
      3,
      27,
      179.097046,
      200.274823,
      ' 4- 6-1978',
      3.814546,
      5.299015,
      6,
      1,
      7,
      NULL,
      7,
      1,
      3.683245,
      0,
      2,
      1,
      0.460063,
      0.037803,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1996',
      28,
      19.033532,
      5,
      5,
      7.657564,
      NULL,
      ' 5-29-1974',
      0,
      0,
      54.711139,
      0.826247,
      3,
      NULL,
      1,
      2,
      15.185775,
      NULL,
      NULL,
      NULL,
      '10- 0-1996',
      NULL,
      7,
      12.179617,
      109.185709,
      114.383430,
      60,
      50.450259,
      65.929992,
      53.487904,
      NULL,
      90,
      46.912992,
      '10-14-1974',
      3,
      11.682442,
      11.297229,
      7.882056,
      29.145676,
      14,
      1.303781,
      ' 8-22-1987',
      26.343139,
      NULL,
      ' 1-19-1985',
      5.621667,
      NULL,
      2,
      NULL,
      8.610426,
      7.516297,
      1,
      3.426559,
      0,
      79,
      0.038586,
      1,
      2,
      7.509398,
      5.618368,
      NULL,
      1,
      1.368573,
      '10-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.741902,
      '11-12-1996',
      NULL,
      NULL,
      NULL,
      6,
      ' 5-25-1985',
      18,
      ' 4- 4-1986',
      4,
      11,
      NULL,
      103,
      37.441347,
      NULL,
      3.972775,
      10,
      '11- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10,
      NULL,
      36,
      NULL,
      28.673110,
      ' 2- 9-1994',
      2.612690,
      130.266088,
      ' 1-10-1981',
      10.636777,
      41,
      15,
      50.704056,
      '11-23-1981',
      1.109227,
      1.679001,
      276,
      ' 4-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


