set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1414',
      '02140200',
      '12414432',
      '23402203',
      '41343132',
      '40001001',
      '41131434',
      '21121204',
      '44301130',
      '34303332',
      '04343342',
      '42221311',
      '12004344',
      NULL,
      NULL,
      '04300332',
      '22204410',
      '30330442',
      '13001040',
      '44330023',
      '14143433',
      '11234210',
      '40331314',
      '32314320',
      '34434043',
      '03131132',
      '34244401',
      '32024031',
      '10124120',
      NULL,
      '32100023',
      '43013211',
      '41412403',
      '00330203',
      '30141003',
      '04123342',
      '01312000',
      '11212024',
      '21312331',
      NULL,
      '31103412',
      NULL,
      NULL,
      '30303001',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '0400001',
      0,
      1.279134,
      1,
      NULL,
      '103430',
      1,
      ' 8-25-1986',
      NULL,
      27.459833,
      NULL,
      7,
      0,
      NULL,
      12,
      23.321642,
      0.217491,
      NULL,
      9,
      10,
      9.488081,
      10.053826,
      0,
      20.591430,
      0.834204,
      3.322543,
      6.252349,
      NULL,
      10.272688,
      5,
      NULL,
      37.314404,
      7,
      NULL,
      49.355967,
      125,
      52,
      111.990155,
      70,
      58,
      ' 6-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.905214,
      9.408584,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.679589,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      32.962987,
      29,
      30.333338,
      10.189146,
      67,
      97,
      63.186427,
      18.001671,
      35,
      NULL,
      40.061510,
      '10-19-1992',
      4,
      5,
      NULL,
      48,
      39,
      67,
      NULL,
      NULL,
      4,
      1,
      ' 0-12-1975',
      5,
      NULL,
      10,
      NULL,
      10.282860,
      1,
      NULL,
      NULL,
      NULL,
      34,
      7.275264,
      4,
      4.996534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      3.514113,
      8,
      ' 2-11-1983',
      1,
      285.534617,
      ' 3-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021131,
      4,
      NULL,
      NULL,
      87.302149,
      109.492560,
      NULL,
      NULL,
      20,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752603,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740407,
      16,
      0.373771,
      3.275491,
      3.902014,
      1.785021,
      4.168024,
      3.058023,
      NULL,
      '10-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1980',
      NULL);
commit;
end;
/


