set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9128147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '34201022',
      '03320333',
      NULL,
      '14101410',
      '03240313',
      '34404412',
      NULL,
      '00431140',
      '20201320',
      '13334101',
      '24411001',
      NULL,
      '31413244',
      NULL,
      '23440132',
      '03122232',
      '12432330',
      NULL,
      '13343241',
      '23242033',
      '34144213',
      '01400030',
      '21044201',
      '20402013',
      '01042234',
      '10344132',
      '02030420',
      '42444410',
      '42314420',
      '12410303',
      '32114440',
      '32132400',
      '22400420',
      '24210304',
      '34332332',
      '22210032',
      '33024443',
      '22334002',
      '32024404',
      '40124431',
      '22143301',
      '01423433',
      '40300334',
      '122',
      '20',
      NULL,
      NULL,
      NULL,
      3,
      47,
      1,
      NULL,
      NULL,
      1,
      ' 0-20-1994',
      ' 0-23-1976',
      22.553454,
      NULL,
      10.349761,
      7.477363,
      4.492546,
      1.800239,
      34,
      2.669834,
      2,
      2.901731,
      1.846051,
      3,
      NULL,
      3.504027,
      5.184905,
      10.275433,
      2.189837,
      5.371123,
      NULL,
      0.205493,
      34,
      NULL,
      26,
      4,
      NULL,
      47,
      NULL,
      19,
      59.941686,
      NULL,
      55,
      ' 9-10-1977',
      5.370223,
      NULL,
      16,
      1,
      NULL,
      85,
      ' 9-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      25.736614,
      8,
      NULL,
      3.290480,
      ' 8-11-1985',
      3,
      0,
      NULL,
      1.840306,
      0,
      37.295954,
      NULL,
      6,
      25,
      NULL,
      NULL,
      NULL,
      ' 5- 8-1991',
      45,
      45,
      31,
      104,
      3.681522,
      77,
      34.147782,
      40.209446,
      NULL,
      76.130944,
      47,
      61.231903,
      ' 3-19-1978',
      7,
      14,
      NULL,
      25.456987,
      37.408115,
      39,
      9,
      ' 0- 8-1983',
      5,
      5,
      ' 7-27-1994',
      4.615888,
      NULL,
      4,
      1.123655,
      4,
      4,
      NULL,
      NULL,
      0,
      16.885493,
      1.764800,
      NULL,
      1.175274,
      NULL,
      0.329878,
      5,
      9,
      1.354744,
      '10- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.221982,
      ' 7-28-1992',
      40,
      ' 9- 3-2003',
      5.131568,
      13.569839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122827,
      ' 8-14-1983',
      NULL,
      NULL,
      NULL,
      3,
      3,
      5.059335,
      ' 0-29-1983',
      23,
      1,
      3.891974,
      ' 5- 7-1976',
      NULL,
      NULL,
      NULL,
      5.527955,
      NULL,
      NULL,
      38.791083,
      ' 2- 7-1998',
      NULL,
      1.761601,
      130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


